% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.R
\name{block}
\alias{block}
\title{Block the design}
\usage{
block(x, blocks, target = 5e-04, max_iter = 1e+06)
}
\arguments{
\item{x}{An object of class 'spdesign'}

\item{blocks}{An integer giving the number of blocks. The number of blocks
must be a multiple of the number of rows to ensure equal number of choices
within a block.}

\item{target}{A target value for the mean squared correlation. The default
value is 0.0005. Setting the target to 0 forces the function to search all
`max_iter` blocking candidates}

\item{max_iter}{The maximum number of candidates to consider before returning
the best blocking candidate. The default value is 1000000.}
}
\value{
A modified 'spdesign' object where the design is replaced with the
same design and a blocking column. In addition a correlation vector, number
of iterations and the target value are returned as part of the modified
'spdesign' object.
}
\description{
The function will take an object of class 'spdesign' and add a blocking
column to the design matrix. The function will use random permutations of
the blocking column to find the column that minimizes correlation between
the blocking column and the design columns. Specifically the target for the
minimization procedure is the mean squared correlation.
}
\details{
The function uses a random permutation so every time you run the function
you will get a slightly different blocking column. You can set a seed prior
to calling the function to always return the same blocking vector.

If you pass in a design that already contains a blocking column, then this
blocking column will be replaced without warning.
}
