% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/CUSUM.R, R/EWMA.R, R/shewhart.R
\docType{methods}
\name{runchart}
\alias{runchart}
\alias{runchart,SPCCUSUM-method}
\alias{runchart,SPCEWMA-method}
\alias{runchart,SPCShew-method}
\title{Runs a chart}
\usage{
runchart(chart, newdata, xi)

\S4method{runchart}{SPCCUSUM}(chart, newdata, xi)

\S4method{runchart}{SPCEWMA}(chart, newdata, xi)

\S4method{runchart}{SPCShew}(chart, newdata, xi)
}
\arguments{
\item{chart}{the chart to be used.}

\item{newdata}{the new observed data.}

\item{xi}{the parameters to be used in running the chart.}
}
\value{
The path of the chart over time.
}
\description{
Generic method for running a chart on new data using given
parameters \code{xi}.
}
\section{Methods (by class)}{
\itemize{
\item \code{SPCCUSUM}: Generic function for running CUSUM
charts. Relies on \code{\link{updates}} being implemented for the
chart.

\item \code{SPCEWMA}: Generic function for running EWMA
charts. Relies on \code{\link{updates}} being implemented for the
chart.

\item \code{SPCShew}: Simply computes the updates appropriate for
the Shewhart chart and returns them.
}}

