\name{runifpoint}
\alias{runifpoint}
\title{Generate N Uniform Random Points}
\description{
  Generate a random point pattern
  containing \eqn{n} independent uniform random points.
}
\usage{
 runifpoint(n, win=owin(c(0,1),c(0,1)), giveup=1000, warn=TRUE)
}
\arguments{
  \item{n}{
    Number of points.
  }
  \item{win}{
    Window in which to simulate the pattern.
    An object of class \code{"owin"}
    or something acceptable to \code{\link{as.owin}}.
  }
  \item{giveup}{
    Number of attempts in the rejection method after which
    the algorithm should stop trying to generate new points.
  }
  \item{warn}{
    Logical. Whether to issue a warning if \code{n} is very large.
    See Details.
  }
}
\value{
  The simulated point pattern (an object of class \code{"ppp"}).
}
\details{
  This function generates \code{n} independent random points,
  uniformly distributed in the window \code{win}.
  (For nonuniform distributions, see \code{\link{rpoint}}.)

  The algorithm depends on the type of window, as follows:
  \itemize{
    \item
    If \code{win} is a rectangle then 
    \eqn{n} independent random points, uniformly distributed
    in the rectangle, are generated by assigning uniform random values to their
    cartesian coordinates.
    \item
    If \code{win} is a binary image mask, then a random sequence of 
    pixels is selected (using \code{\link{sample}})
    with equal probabilities. Then for each pixel in the sequence
    we generate a uniformly distributed random point in that pixel.
    \item
    If \code{win} is a polygonal window, the algorithm uses the rejection
    method. It finds a rectangle enclosing the window,
    generates points in this rectangle, and tests whether they fall in
    the desired window. It gives up when \code{giveup * n} tests
    have been performed without yielding \code{n} successes.
  }
  The algorithm for binary image masks is faster than the rejection
  method but involves discretisation.

  If \code{warn=TRUE}, then a warning will be issued if \code{n} is very large.
  The threshold is \code{\link{spatstat.options}("huge.npoints")}.
  This warning has no consequences,
  but it helps to trap a number of common errors.
}
\seealso{
\code{\link{ppp.object}},
\code{\link{owin.object}},
\code{\link{rpoispp}},
\code{\link{rpoint}}
}
\examples{
 # 100 random points in the unit square
 pp <- runifpoint(100)
 # irregular window
 data(letterR)
 # polygonal
 pp <- runifpoint(100, letterR)
 # binary image mask
 pp <- runifpoint(100, as.mask(letterR))
}
\author{Adrian Baddeley
  \email{Adrian.Baddeley@csiro.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
\keyword{datagen}

