library(spatialreg)
# https://github.com/r-spatial/spatialreg/issues/7
data(oldcol, package="spdep")
W <- spdep::nb2listw(COL.nb, style="W")
expect_warning(dem <- lmSLX(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = W, Durbin=TRUE))
summary(impacts(dem))
expect_warning(dem1 <- lmSLX(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = W, Durbin=~ 0 + INC))
summary(impacts(dem1))
expect_silent(sem <- errorsarlm(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = W))
expect_error(impacts(sem))
expect_silent(sdem <- errorsarlm(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = W,  Durbin=TRUE))
summary(impacts(sdem))
expect_silent(sdem1 <- errorsarlm(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = W,  Durbin=~ 0 + INC))
summary(impacts(sdem1))
B <- spdep::nb2listw(COL.nb, style="B")
expect_warning(demB <- lmSLX(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = B, Durbin=TRUE))
summary(impacts(demB))
expect_warning(dem1B <- lmSLX(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = B, Durbin=~ 0 + INC))
summary(impacts(dem1B))
expect_silent(semB <- errorsarlm(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = B))
expect_error(impacts(semB))
expect_silent(sdemB <- errorsarlm(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = B,  Durbin=TRUE))
summary(impacts(sdemB))
expect_silent(sdem1B <- errorsarlm(CRIME ~ 0 + INC + HOVAL, data = COL.OLD, listw = B,  Durbin=~ 0 + INC))
summary(impacts(sdem1B))

