% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spseg.R
\name{spseg.matrix}
\alias{spseg.matrix}
\alias{plotcv}
\alias{plotphat}
\alias{plotmc}
\alias{spseg}
\alias{spseg.ppp}
\title{Integrated Functions for Spatial Segregation Analysis
Spatial segregation analysis to be performed by a single function and
presentations by associated \code{plot} functions.}
\usage{
\method{spseg}{matrix}(pts, marks, h, opt = 2, ntest = 100, poly = NULL,
  delta = min(apply(apply(pts, 2, range), 2, diff))/100, proc = TRUE, ...)

plotcv(obj, ...)

plotphat(obj, types = unique(obj$marks), sup = TRUE,
  col = risk.colors(10), breaks = seq(0, 1, length = length(col) + 1), ...)

plotmc(obj, types = unique(obj$marks), quan = c(0.05, 0.95), sup = FALSE,
  col = risk.colors(10), breaks = seq(0, 1, length = length(col) + 1), ...)

spseg(pts, ...)

\method{spseg}{ppp}(pts, h, opt, ...)
}
\arguments{
\item{pts}{an object that contains the points. This could be a two-column
matrix or a ppp object from spatstat.}

\item{marks}{numeric/character vector of the types of the point in the data.}

\item{h}{numeric vector of the kernel smoothing bandwidth at which to
calculate the cross-validated log-likelihood function.}

\item{opt}{integer, 1 to select bandwidth; 2 to calculate type-specific 
probabilities; and 3 to do the Monte Carlo segregation test.}

\item{ntest}{integer with default 100, number of simulations for the 
Monte Carlo test.}

\item{poly}{matrix containing the \code{x,y}-coordinates of the polygonal
boundary of the data.}

\item{delta}{spacing distance of grid points at which to calculate the estimated
type-specific probabilities for \code{\link{image}} plot.}

\item{proc}{logical with default \code{TRUE} to print the
processing message.}

\item{\dots}{other arguments concerning \code{\link{plot}} and 
\code{\link{points}}}

\item{obj}{list of the returning value of \code{spseg}.}

\item{types}{numeric/character types of the marks of data points to plot
the estimated type-specific probabilities, default to plot all types.}

\item{sup}{logical with default \code{FALSE}, if \code{TRUE} to superimpose data points 
on the estimated type-specific probability surface.}

\item{col}{list of colors such as that generated by \code{risk.colors}.}

\item{breaks}{a set of breakpoints for the \code{col}: must give one more 
breakpoint than colour.}

\item{quan}{numeric, the pointwise significance levels to add contours to 
\code{\link{image}} plot of the estimated type-specific probability
surface, with default of \code{c(0.05, 0.95)}.}
}
\value{
A list with components 
\describe{
  \item{hcv}{bandwidth selected by the cross-validated log-likelihood
    function.}
  \item{gridx,gridy}{\code{x, y} coordinate vectors at which the grid points 
    are generated at which to calculate the type-specific probabilities 
    and pointwise segregation test \emph{p}-value.}
  \item{p}{estimated type-specific probabilities at grid points generated
    by vectors \code{gridx, gridy}.}
  \item{pvalue}{\emph{p}-value of the Monte Carlo spatial segregation test.}
  \item{stpvalue}{pointwise \emph{p}-value of the Monte Carlo spatial 
    segregation test.}
  \item{...}{copy of \code{pts, marks, h, opt}.}
}

spseg results

an spseg object
}
\description{
Integrated Functions for Spatial Segregation Analysis
Spatial segregation analysis to be performed by a single function and
presentations by associated \code{plot} functions.

Run the spatial segregation analysis

spseg for spatstat objects
}
\details{
\code{spseg} implements a complete spatial segregation analysis by
  selecting bandwidth, calculating the type-specific probabilities, and then
  carrying out the Monte Carlo test of spatial segregation and pointwise
  significance. Some \code{plot} functions are also provided here so that
  users can easily present the results.
  
  These functions are provided only for the convenience of users. Users can
  instead use individual functions to implement the analysis step by step and
  plot the diagrams as they wish.
  
  Examples of how to use \code{spseg} and present results using \code{plot}
  functions are presented in \code{\link{spatialkernel-package}}.

This is the details of the S3 generic method

Does spseg for marked ppp objects
}
\note{
Setting \code{h} to a unique value may force \code{spseg} to skip the
  selecting bandwidth step, go straight to calculate the type-specific 
  probabilities and then test the spatial segregation with this fixed
  value of bandwidth.
}
\seealso{
\code{\link{cvloglk}}, \code{\link{phat}}, \code{\link{mcseg.test}}, 
  \code{\link{pinpoly}}, \code{\link{risk.colors}}, and \code{\link{metre}}
}
\author{
Barry Rowlingson

Barry Rowlingson
}
\keyword{hplot}
\keyword{nonparametric}
\keyword{spatial}
