% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_multithreshold.R
\name{pca_multithreshold}
\alias{pca_multithreshold}
\title{PCA of a distance matrix over distance thresholds}
\usage{
pca_multithreshold(
  distance.matrix = NULL,
  distance.thresholds = NULL,
  max.spatial.predictors = NULL
)
}
\arguments{
\item{distance.matrix}{Distance matrix. Default: \code{NULL}}

\item{distance.thresholds}{Numeric vector with distance thresholds defining neighborhood in the distance matrix, Default: \code{0}}

\item{max.spatial.predictors}{Integer, maximum number of spatial predictors to generate. Only useful when the distance matrix \code{x} is very large. Default: \code{NULL}}
}
\value{
A data frame with the PCA factors of the thresholded matrix. The data frame columns are named "spatial_predictor_DISTANCE_COLUMN", where DISTANCE is the given distance threshold, and COLUMN is the column index of the given predictor.
}
\description{
Computes PCA factors of a distance matrix over different distance thresholds to generate spatial predictors for a model fitted with \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
The distance matrix is converted into weights with \code{\link[=weights_from_distance_matrix]{weights_from_distance_matrix()}} before computing the PCA. This produces more meaningful spatial predictors than using the distance matrix as is.
}
\examples{
if(interactive()){

 #loading example distance matrix
 load(distance_matrix)

 #PCA factors of the distance matrix for two reference distances
 x <- pca_multithreshold(
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 1000)
   )
 head(x)

}
}
\seealso{
\code{\link[=pca]{pca()}}
}
