% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mem_multithreshold.R
\name{mem_multithreshold}
\alias{mem_multithreshold}
\title{Moran's Eigenvector Maps for different distance thresholds}
\usage{
mem_multithreshold(
  distance.matrix = NULL,
  distance.thresholds = NULL,
  max.spatial.predictors = NULL
)
}
\arguments{
\item{distance.matrix}{Distance matrix. Default: \code{NULL}.}

\item{distance.thresholds}{Numeric vector with distance thresholds defining neighborhood in the distance matrix, Default: \code{NULL}.}

\item{max.spatial.predictors}{Maximum number of spatial predictors to generate. Only useful to save memory when the distance matrix \code{x} is very large. Default: \code{NULL}.}
}
\value{
A data frame with as many rows as the distance matrix \code{x} containing positive Moran's Eigenvector Maps. The data frame columns are named "spatial_predictor_DISTANCE_COLUMN", where DISTANCE is the given distance threshold, and COLUMN is the column index of the given spatial predictor.
}
\description{
Computes Moran's Eigenvector Maps of a distance matrix (using \code{\link[=mem]{mem()}}) over different distance thresholds.
}
\details{
The function takes the distance matrix \code{x}, computes its weights at difference distance thresholds, double-centers the resulting weight matrices with \code{\link[=double_center_distance_matrix]{double_center_distance_matrix()}}, applies \link[base]{eigen} to each double-centered matrix, and returns eigenvectors with positive normalized eigenvalues for different distance thresholds.
}
\examples{
if(interactive()){

 #loading example data
 data(distance_matrix)

 #computing Moran's eigenvector maps for 0, 1000, and 2000 km
 mem.df <- mem_multithreshold(
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 1000, 2000)
   )
 head(mem.df)

}
}
