% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_SThet.R
\name{compare_SThet}
\alias{compare_SThet}
\title{compare_SThet: Compares spatial autocorrelation statistics across samples}
\usage{
compare_SThet(
  x = NULL,
  samplemeta = NULL,
  genes = NULL,
  color_by = NULL,
  categorical = TRUE,
  color_pal = "muted",
  ptsize = 1
)
}
\arguments{
\item{x}{an STlist.}

\item{samplemeta}{a string indicating the name of the variable in the clinical
data frame. If NULL, uses sample names}

\item{genes}{the name(s) of the gene(s) to plot.}

\item{color_by}{the variable in \code{x@spatial_meta} used to color points in the plot.
If NULL, each sample is assigned a different color}

\item{categorical}{logical indicating whether or not to treat \code{color_by} as a
categorical variable. Default is TRUE}

\item{color_pal}{a string of a color palette from khroma or RColorBrewer, or a
vector with colors with enough elements to plot categories.}

\item{ptsize}{a number specifying the size of the points. Passed to the \code{size}
aesthetic.}
}
\value{
a list of plots
}
\description{
Plots the spatial autocorrelation statistics of genes across samples and
colors samples acording to sample metadata.
}
\details{
This function takes the names of genes and their Moran's I or Geary's C computed for
multiple samples and to provide a muti-sample comparison. Samples in the plot can
be colored according to sample metadata to explore potential associations between
spatial distribution of gene expression and sample-level data.
}
