% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt.centroids.R
\name{wt.centroid}
\alias{wt.centroid}
\title{Weighted centroid}
\usage{
wt.centroid(x, p = NULL, spatial = TRUE)
}
\arguments{
\item{x}{sf POINT class object}

\item{p}{Weights column in x}

\item{spatial}{(TRUE/FALSE) Output sf POINT object}
}
\value{
An x,y coordinate or sf POINT object representing the weighted or unweighted 
coordinate centroid
}
\description{
Creates centroid of [x,y] coordinates with optional
             weights field
}
\details{
The weighted centroid is calculated as:
[Xw]=[X]*[p], [Yw]=[Y]*[p], [sXw]=SUM[Xw], [sYw]=SUM[Yw], [sP]=SUM[p]
   wX=[sXw]/[sP], wY=[sYw]/[sP]    
   where; X=X coordinate(S), Y=Y coordinate(S), p=WEIGHT
}
\examples{
p = c("sf", "sp")
if(any(!unlist(lapply(p, requireNamespace, quietly=TRUE)))) { 
  m = which(!unlist(lapply(p, requireNamespace, quietly=TRUE)))
  message("Can't run examples, please install ", paste(p[m], collapse = " "))
} else {
invisible(lapply(p, require, character.only=TRUE))

data(meuse, package = "sp")
meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, 
                  agr = "constant")

wt.copper <- wt.centroid(meuse, p='copper') 
wt.zinc <- wt.centroid(meuse,  p='zinc') 

plot(st_geometry(meuse), pch=20, cex=0.75, 
     main='Weighted centroid(s)')
  plot(st_geometry(wt.copper), pch=19, col='red', 
       cex=1.5, add=TRUE)  
  plot(st_geometry(wt.zinc), pch=19, col='blue', 
       cex=1.5, add=TRUE)
legend('topleft', legend=c('all','copper', 'zinc'), 
       pch=c(20,19,19),col=c('black','red','blue'))
}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
