% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_to_event.R
\name{time_to_event}
\alias{time_to_event}
\title{Time to event}
\usage{
time_to_event(x, y = 1, dir = c("LR", "RL"), int = FALSE, up.to = FALSE)
}
\arguments{
\item{x}{A vector, representing time-series, to evaluate}

\item{y}{Threshold value tor return position for}

\item{dir}{Direction of evaluation c("LR", "RL")}

\item{int}{FALSE | TRUE - Evaluate as integer (rounds to 0 decimal places)}

\item{up.to}{FALSE | TRUE - Return value before event}
}
\value{
A vector value representing the time to event
}
\description{
Returns the time (sum to position) to a specified value

The time to event represents the sum of positions, in the vector,
until the specified value is found ie., (0,0,1) would be 3 or, 
2 with up.to=TRUE. The int argument allows for rounding a continuous  
variable. Since it may be difficult to fine an exact match to a floating 
point value rounding mitigates the problem. If you want a specific rounding 
value (eg., 1 decimal place) you can apply it to x first then pass it to 
the function.
}
\examples{

library(raster)

# Binomial instance
time_to_event(c(0,0,0,0,1,0,0,0,1,0))
time_to_event(c(0,0,0,0,1,0,0,0,1,0), up.to = TRUE)
time_to_event(c(0,0,0,0,1,0,0,0,1,0), dir="RL")

r <- do.call(raster::stack, replicate(20,raster::raster(matrix(sample(
             c(0,1), 1000, replace=TRUE), 100, 100))))             
  ( t2e <- calc(r, fun=time_to_event) )

# Continuous threshold instance
( x <- runif(100, 0,7) ) 
time_to_event(x, y = 5, int=TRUE)

r <- do.call(raster::stack, replicate(20,raster::raster(matrix(
             runif(1000,0,7), 100, 100))))
  t2e <- function(x) { time_to_event(x, y=5, int=TRUE) }              
  ( t2e <- calc(r, fun=time_to_event) )

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
