% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_plotting.R
\name{ortho3}
\alias{ortho3}
\title{Display an orthographic projection plot of a nifti object.}
\usage{
ortho3(
  underlay,
  overlay = NULL,
  xyz = NULL,
  zlim = NULL,
  zlim_ol = NULL,
  alpha = 0.7,
  col_ol = viridisLite::viridis(64),
  orient_lab = TRUE,
  rescale = 1,
  crosshairs = TRUE,
  ch_lwd = 1,
  colourbar = TRUE,
  bg = "black",
  mar = c(0, 0, 0, 0),
  smallplot = c(0.63, 0.65, 0.07, 0.42)
)
}
\arguments{
\item{underlay}{underlay image to be shown in grayscale.}

\item{overlay}{optional overlay image.}

\item{xyz}{x, y, z slice coordinates to display.}

\item{zlim}{underlay intensity limits.}

\item{zlim_ol}{overlay intensity limits.}

\item{alpha}{transparency of overlay.}

\item{col_ol}{colour palette of overlay.}

\item{orient_lab}{display orientation labels (default TRUE).}

\item{rescale}{rescale factor for the underlay and overlay images.}

\item{crosshairs}{display the crosshairs (default TRUE).}

\item{ch_lwd}{crosshair linewidth.}

\item{colourbar}{display a colourbar for the overlay (default TRUE).}

\item{bg}{plot background colour.}

\item{mar}{plot margins.}

\item{smallplot}{smallplot option for positioning the colourbar.}
}
\description{
Display an orthographic projection plot of a nifti object.
}
