% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs_batch_fit.R
\name{svs_1h_brain_analysis_dev}
\alias{svs_1h_brain_analysis_dev}
\title{Standard SVS 1H brain analysis pipeline.}
\usage{
svs_1h_brain_analysis_dev(
  metab,
  w_ref = NULL,
  output_dir = NULL,
  p_vols = NULL,
  append_basis = NULL,
  remove_basis = NULL,
  basis = NULL,
  dfp_corr = TRUE,
  omit_bad_dynamics = TRUE,
  te = NULL,
  tr = NULL,
  output_ratio = "tCr",
  ecc = FALSE,
  fit_opts = NULL,
  verbose = FALSE
)
}
\arguments{
\item{metab}{filepath or mrs_data object containing MRS metabolite data.}

\item{w_ref}{filepath or mrs_data object containing MRS water reference data.}

\item{output_dir}{directory path to output fitting results.}

\item{p_vols}{a numeric vector of partial volumes expressed as percentages.
Defaults to 100\% white matter. A voxel containing 100\% gray matter tissue
would use : p_vols = c(WM = 0, GM = 100, CSF = 0).}

\item{append_basis}{names of extra signals to add to the default basis. Eg
append_basis = c("peth", "cit"). Cannot be used with precompiled basis sets.}

\item{remove_basis}{names of signals to remove from the basis. Cannot be used
with precompiled basis sets.}

\item{basis}{basis set object to use for analysis.}

\item{dfp_corr}{perform dynamic frequency and phase correction using the RATS
method.}

\item{omit_bad_dynamics}{detect and remove bad dynamics.}

\item{te}{metabolite mrs data echo time in seconds. If not supplied this will
be guessed from the metab data file.}

\item{tr}{metabolite mrs data repetition time in seconds. If not supplied
this will be guessed from the metab data file.}

\item{output_ratio}{optional string to specify a metabolite ratio to output.
Defaults to "tCr" and multiple metabolites may be specified for multiple
outputs. Set to NULL to omit.}

\item{ecc}{option to perform water reference based eddy current correction,
defaults to FALSE.}

\item{fit_opts}{options to pass to the fitting method.}

\item{verbose}{output potentially useful information.}
}
\description{
Standard SVS 1H brain analysis pipeline.
}
