% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetSim.R
\name{NetSim}
\alias{NetSim}
\title{Simulate a network from a point process or sequence}
\usage{
NetSim(point_sim, sif, base_prob, scale, threshold, power)
}
\arguments{
\item{point_sim}{a PointSim object}

\item{sif}{the spatial interaction function to use. Use attenuated to use an
attenuated power law; arctan to use an arctangent probability law; decay to
use an exponential decay law; or logistic to use a logistic probability law.
Default is a standard power law function.}

\item{base_prob}{the theoretical probability that two nodes (points) with
distance 0 share a tie. Default is 0.9.}

\item{scale}{a coefficient to multiply the distance by. Default is 1.}

\item{threshold}{if two node exceed this probability, they will be coded as
having a tie. Default is 0.5.}

\item{power}{the exponent at which tie probability decays. Default is -2.8.}
}
\value{
A network object of class 'NetSim' and 'igraph' that can be
manipulated using the igraph' package.
}
\description{
Simulates a spatial Bernoulli network from a NetSim object
using one of six probability law distributions.
}
\details{
The algorithm proceeds in three steps. First, it calculates the
distance between simulated points from a PointSim object. Then it calculates
the distance between all pairs of points. Finally, it uses a spatial
interaction function to calculate that any two point share a tie. If the
threshold is exceeded, a tie is created.
}
\examples{
# Load spacejamr object
data("RI")

ri_points <- PointSim(points = 10, window = RI, seed = 42)
power_law <- NetSim(ri_points, base_prob = 0.92, scale = 1, threshold = 0.5,
                    power = -2.4)

}
\references{
Butts, Carter T. Spatial models of large-scale interpersonal
networks. Dissertation. (2002).
}
\author{
Darren Colby \cr
Email: dscolby17@gmail.com
}
