.hack_options_error <- local({
  .R_errorfn <- NULL ## keep original error-handling function, "stop" or "recover" of rstudio stuff
  .message <- NULL ## the message to show when an error occurs
  function(message=NULL) {
    if ( ! is.null(message)) {
      if (is.null(.R_errorfn)) { ## Do not call options("error"=errorfn) twice !
        # see ?options for error:
        # either a function or an expression governing the handling of non-catastrophic errors such as those generated by 
        # stop as well as by signals and internally detected errors. If the option is a function, a call to that function, 
        # with no arguments, is generated as the expression.
        .R_errorfn <<- loc_fn_call <- getOption("error") ## original error-handling function call: save it to be able to restore it, 
        # and make a local copy for (R CMD check not complaining about) the following definition:
        errorWrap <- function() {
          message(paste0("An error occurred, possibly due to the following earlier issue:\n", .message))
          options(error=loc_fn_call[[1L]]) ## [[]] gets the original error-handling function from the call and restores it
          eval(loc_fn_call) ## stop or recover
        }
        options("error"=errorWrap) 
      }
      .message <<- message ## possibly updating the message.
    } else if ( ! is.null(.R_errorfn)) { ## cleans everything
      options("error"=.R_errorfn[[1L]]) ## [[]] gets the original error-handling function from the call and restores it
      .R_errorfn <<- NULL
      .message <<- NULL
    }
  }
})