% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinar_est_param.R
\name{spinar_est_param}
\alias{spinar_est_param}
\title{Parametric estimation of INAR models}
\usage{
spinar_est_param(x, p, type, distr)
}
\arguments{
\item{x}{[\code{integer}]\cr
vector with integer observations.}

\item{p}{[\code{integer(1)}]\cr
order of the INAR model, where \eqn{\code{p} \in \{1,2\}}.}

\item{type}{[\code{string(1)}]\cr
type of estimation \eqn{\in \code{\{"mom", "ml"\}}}, where \code{"mom"} performs moment-based estimation and
\code{"ml"} maximum likelihood-based estimation.}

\item{distr}{[\code{string(1)}]\cr
parametric family of innovation distribution \eqn{\in  \code{\{'poi', 'geo', 'nb'\}}}, where \code{"poi"} denotes
Poi(\code{lambda}), \code{"geo"} Geo(\code{prob}) and \code{"nb"} NB(\code{r}, \code{prob}) distributions.}
}
\value{
Named vector containing the estimated coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p} and the estimated parameter(s)
of the innovation distribution.
}
\description{
Parametric estimation of the autoregressive parameters and the innovation distribution of INAR(\code{p}) models,
\eqn{\code{p} \in \{1,2\}}, with Poisson, geometrically or negative binomially distributed innovations. The estimation can either be
moment- or maximum likelihood-based.
}
\examples{
# generate data
# Poi-INAR(1) data
dat1 <- spinar_sim(n = 200, p = 1, alpha = 0.5, pmf = dpois(0:20, 1))
# Geo-INAR(2) data
dat2 <- spinar_sim(n = 200, p = 2, alpha = c(0.2, 0.3),
                   pmf = dgeom(0:60, 0.5))
# NB-INAR(1) data
dat3 <- spinar_sim(n = 200, p = 1, alpha = 0.5, pmf = dnbinom(0:40, 2, 2/3))

# moment-based parametric estimation of Poi-INAR(1) model
spinar_est_param(x = dat1, p = 1, type = "mom", distr = "poi")
# moment-based parametric estimation of Geo-INAR(2) model
spinar_est_param(x = dat2, p = 2, type = "mom", distr = "geo")
# maximum likelihood-based parametric estimation of NB-INAR(1) model
spinar_est_param(x = dat3, p = 1, type = "ml", distr = "nb")

}
