% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateNoise.R
\name{generateNoise}
\alias{generateNoise}
\title{Add noise to a Wave like object}
\usage{
generateNoise(
  wave,
  noise = c("white"),
  noise.add = FALSE,
  noise.ratio = 0.5,
  noise.ref = "file",
  output = "list"
)
}
\arguments{
\item{wave}{Object to add noise to (\code{Wave}, \code{WaveMC}, or Tagged versions), or
a list of such objects.}

\item{noise}{Vector of noise to add (unif, gaussian, white, pink, power, red)}

\item{noise.add}{If TRUE all noise sources are added to wave. If FALSE
separate outputs are created for each noise source.}

\item{noise.ratio}{Ratio of maximum noise amplitude to the maximum amplitude in wave.}

\item{noise.ref}{Reference maximum for noise.ratio. If "max" then the maximum
amplitude, if "file" then the maximum amplitude of wave.}

\item{output}{TODO: Is this implemented?}
}
\value{
A list of Wave objects with the required noise added.
}
\description{
Adding noise to a Wave like object allows for testing of the robustness of
automated identification algorithms to noise.
}
