% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSDquery.R
\name{OSDquery}
\alias{OSDquery}
\title{Search full text of Official Series Description on SoilWeb}
\usage{
OSDquery(
  everything = NULL,
  mlra = "",
  taxonomic_class = "",
  typical_pedon = "",
  brief_narrative = "",
  ric = "",
  use_and_veg = "",
  competing_series = "",
  geog_location = "",
  geog_assoc_soils = ""
)
}
\arguments{
\item{everything}{search entire OSD text (default is NULL), \code{mlra} may also be specified, all other arguments are ignored}

\item{mlra}{a comma-delimited string of MLRA to search ('17,18,22A')}

\item{taxonomic_class}{search family level classification}

\item{typical_pedon}{search typical pedon section}

\item{brief_narrative}{search brief narrative}

\item{ric}{search range in characteristics section}

\item{use_and_veg}{search use and vegetation section}

\item{competing_series}{search competing series section}

\item{geog_location}{search geographic setting section}

\item{geog_assoc_soils}{search geographically associated soils section}
}
\value{
a \code{data.frame} object containing soil series names that match patterns supplied as arguments.
}
\description{
This is the R interface to \href{https://casoilresource.lawr.ucdavis.edu/osd-search/}{OSD search by Section} and \href{https://casoilresource.lawr.ucdavis.edu/osd-search/search-entire-osd.php}{OSD Search} APIs provided by SoilWeb.

OSD records are searched with the \href{https://www.postgresql.org/docs/9.5/textsearch.html}{PostgreSQL fulltext indexing} and query system (\href{https://www.postgresql.org/docs/9.5/datatype-textsearch.html}{syntax details}). Each search field (except for the "brief narrative" and MLRA) corresponds with a section header in an OSD. The results may not include every OSD due to formatting errors and typos. Results are scored based on the number of times search terms match words in associated sections.
}
\details{
See \href{https://casoilresource.lawr.ucdavis.edu/osd-search/}{this webpage} for more information.
\itemize{
\item family level taxa are derived from SC database, not parsed OSD records
\item MLRA are derived via spatial intersection (SSURGO x MLRA polygons)
\item MLRA-filtering is only possible for series used in the current SSURGO snapshot (component name)
\item logical AND: &
\item logical OR: |
\item wildcard, e.g. rhy-something rhy:*
\item search terms with spaces need doubled single quotes: ''san joaquin''
\item combine search terms into a single expression: (grano:* | granite)
}

Related documentation can be found in the following tutorials
\itemize{
\item \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{overview of all soil series query functions}
\item \href{https://ncss-tech.github.io/AQP/soilDB/competing-series.html}{competing soil series}
\item \href{https://ncss-tech.github.io/AQP/soilDB/siblings.html}{siblings}
}
}
\note{
SoilWeb maintains a snapshot of the Official Series Description data.
}
\examples{
\dontshow{if (curl::has_internet() && requireNamespace("httr") && requireNamespace("jsonlite") && require(aqp)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
  # find all series that list Pardee as a geographically associated soil.
  s <- OSDquery(geog_assoc_soils = 'pardee')

  # get data for these series
  x <- fetchOSD(s$series, extended = TRUE, colorState = 'dry')

  # simple figure
  par(mar=c(0,0,1,1))
  plot(x$SPC)
}
\dontshow{\}) # examplesIf}
}
\references{
USDA-NRCS OSD search tools: \url{https://soilseries.sc.egov.usda.gov/}
}
\seealso{
\code{\link{fetchOSD}, \link{siblings}, \link{fetchOSD}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
