% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SDA_interpretation.R
\name{get_SDA_interpretation}
\alias{get_SDA_interpretation}
\title{Get map unit interpretations from Soil Data Access by rule name}
\usage{
get_SDA_interpretation(
  rulename,
  method = c("Dominant Component", "Dominant Condition", "Weighted Average", "None"),
  areasymbols = NULL,
  mukeys = NULL,
  WHERE = NULL,
  include_minors = TRUE,
  miscellaneous_areas = TRUE,
  query_string = FALSE,
  not_rated_value = NA_real_,
  wide_reason = FALSE,
  dsn = NULL
)
}
\arguments{
\item{rulename}{character vector of interpretation rule names (matching \code{mrulename} in \code{cointerp} table)}

\item{method}{aggregation method. One of: "Dominant Component", "Dominant Condition", "Weighted Average", "None". If "None" is selected one row will be returned per component, otherwise one row will be returned per map unit.}

\item{areasymbols}{vector of soil survey area symbols}

\item{mukeys}{vector of map unit keys}

\item{WHERE}{character containing SQL WHERE clause specified in terms of fields in \code{legend}, \code{mapunit}, or \code{component} tables, used in lieu of \code{mukeys} or \code{areasymbols}}

\item{include_minors}{logical. Include minor components? Default: \code{TRUE}.}

\item{miscellaneous_areas}{\emph{logical}. Include miscellaneous areas (non-soil components) in results? Default: \code{TRUE}.}

\item{query_string}{Default: \code{FALSE}; if \code{TRUE} return a character string containing query that would be sent to SDA via \code{SDA_query}}

\item{not_rated_value}{used where rating class is "Not Rated". Default: \code{NA_real_}}

\item{wide_reason}{Default: \code{FALSE}; if  \code{TRUE} apply post-processing to all columns with prefix \code{"reason_"} to create additional columns for sub-rule ratings.}

\item{dsn}{Path to local SQLite database or a DBIConnection object. If \code{NULL} (default) use Soil Data Access API via \code{SDA_query()}.}
}
\value{
a data.frame
}
\description{
Get map unit interpretations from Soil Data Access by rule name
}
\details{
\subsection{Rule Names in \code{cointerp} table}{
\itemize{
\item AGR - Avocado Root Rot Hazard (CA)
\item AGR - California Revised Storie Index (CA)
\item AGR - Hops Site Suitability (WA)
\item AGR - Map Unit Cropland Productivity (MN)
\item AGR - Nitrate Leaching Potential, Nonirrigated (WA)
\item AGR - No Till (TX)
\item AGR - Pesticide Loss Potential-Soil Surface Runoff (NE)
\item AGR - Ridge Till (TX)
\item AGR - Selenium Leaching Potential (CO)
\item AGR - Water Erosion Potential (NE)
\item AGR - Wind Erosion Potential (TX)
\item AGR - Winter Wheat Yield (MT)
\item AGR-Pesticide and Nutrient Runoff Potential (ND)
\item AGR-Rooting Depth (ND)
\item American Wine Grape Varieties Site Desirability (Long)
\item American Wine Grape Varieties Site Desirability (Medium)
\item American Wine Grape Varieties Site Desirability (Very Long)
\item AWM - Animal Mortality Disposal (Catastrophic) (MO)
\item AWM - Irrigation Disposal of Wastewater (OH)
\item AWM - Irrigation Disposal of Wastewater (VT)s
\item AWM - Land Application of Municipal Biosolids, summer (OR)
\item AWM - Manure and Food Processing Waste (MD)
\item AWM - Manure and Food Processing Waste (OH)
\item AWM - Overland Flow Process Treatment of Wastewater (VT)
\item AWM - Rapid Infil Disposal of Wastewater (DE)
\item AWM - Sensitive Soil Features (MN)
\item AWM - Sensitive Soil Features (WI)
\item BLM - Fencing
\item BLM - Fire Damage Susceptibility
\item BLM - Mechanical Treatment, Rolling Drum
\item BLM - Rangeland Drill
\item BLM - Rangeland Seeding, Colorado Plateau Ecoregion
\item BLM - Rangeland Seeding, Great Basin Ecoregion
\item BLM-Reclamation Suitability (MT)
\item CLASS RULE - Depth to lithic bedrock (5 classes) (NPS)
\item CLASS RULE - Soil Inorganic Carbon kg/m2 to 2m (NPS)
\item CLASS RULE - Soil Organic Carbon kg/m2 to 2m (NPS)
\item CLR-pastureland limitation (IN)
\item Commodity Crop Productivity Index (Soybeans) (TN)
\item CPI - Alfalfa Hay, NIRR - Palouse, Northern Rocky Mtns. (WA)
\item CPI - Barley, IRR - Eastern Idaho Plateaus (ID)
\item CPI - Grass Hay, IRR - Klamath Valleys and Basins (OR)
\item CPI - Small Grains, IRR - Snake River Plains (ID)
\item CPI - Wheat, IRR - Eastern Idaho Plateaus (ID)
\item CZSS - Salinization due to Coastal Saltwater Inundation (CT)
\item DHS - Catastrophic Event, Large Animal Mortality, Burial
\item DHS - Catastrophic Mortality, Large Animal Disposal, Pit
\item DHS - Catastrophic Mortality, Large Animal Disposal, Trench
\item DHS - Potential for Radioactive Bioaccumulation
\item DHS - Potential for Radioactive Sequestration
\item DHS - Suitability for Composting Medium and Final Cover
\item ENG - Construction Materials; Gravel Source
\item ENG - Construction Materials; Gravel Source (AK)
\item ENG - Construction Materials; Gravel Source (ID)
\item ENG - Construction Materials; Gravel Source (OH)
\item ENG - Construction Materials; Gravel Source (VT)
\item ENG - Construction Materials; Gravel Source (WA)
\item ENG - Construction Materials; Roadfill (OH)
\item ENG - Construction Materials; Sand Source (OR)
\item ENG - Construction Materials; Sand Source (WA)
\item ENG - Construction Materials; Topsoil (GA)
\item ENG - Construction Materials; Topsoil (MD)
\item ENG - Daily Cover for Landfill
\item ENG - Daily Cover for Landfill (AK)
\item ENG - Disposal Field Suitability Class (NJ)
\item ENG - Dwellings W/O Basements (OH)
\item ENG - Dwellings with Basements (AK)
\item ENG - Large Animal Disposal, Pit (CT)
\item ENG - Lawn, landscape, golf fairway (CT)
\item ENG - Lined Retention Systems
\item ENG - Local Roads and Streets (OH)
\item ENG - On-Site Waste Water Absorption Fields (MO)
\item ENG - Septic Tank Absorption Fields
\item ENG - Septic Tank Absorption Fields (MD)
\item ENG - Septic Tank Absorption Fields (TX)
\item ENG - Septic Tank, Gravity Disposal (TX)
\item ENG - Sewage Lagoons
\item ENG - Small Commercial Buildings (OH)
\item ENG - Soil Potential Ratings of SSDS (CT)
\item FOR (USFS) - Road Construction/Maintenance (Natural Surface)
\item FOR - Compaction Potential (WA)
\item FOR - Conservation Tree/Shrub Groups (MT)
\item FOR - Damage by Fire (OH)
\item FOR - General Harvest Season (VT)
\item FOR - Hand Planting Suitability
\item FOR - Hand Planting Suitability, MO13 (DE)
\item FOR - Hand Planting Suitability, MO13 (MD)
\item FOR - Log Landing Suitability
\item FOR - Log Landing Suitability (ME)
\item FOR - Log Landing Suitability (VT)
\item FOR - Log Landing Suitability (WA)
\item FOR - Mechanical Planting Suitability (CT)
\item FOR - Mechanical Planting Suitability, MO13 (MD)
\item FOR - Mechanical Site Preparation (Deep)
\item FOR - Mechanical Site Preparation (Deep) (DE)
\item FOR - Mechanical Site Preparation (Surface) (DE)
\item FOR - Mechanical Site Preparation (Surface) (MI)
\item FOR - Mechanical Site Preparation; Surface (ME)
\item FOR - Potential Erosion Hazard, Road/Trail, Spring Thaw (AK)
\item FOR - Potential Seedling Mortality (PIA)
\item FOR - Potential Seedling Mortality(ME)
\item FOR - Puddling Hazard
\item FOR - Road Suitability (Natural Surface) (ME)
\item FOR - Road Suitability (Natural Surface) (WA)
\item FOR - Soil Rutting Hazard (OH)
\item FOR - Soil Sustainability Forest Biomass Harvesting (CT)
\item FOR - White Oak Suitability (MO)
\item FOR-Biomass Harvest (WI)
\item FOTG - Indiana Corn Yield Calculation (IN)
\item GRL - Excavations to 24 inches for Plastic Pipelines (TX)
\item GRL - Fencing, 24 inch Post Depth (MT)
\item GRL - NV range seeding (Wind C = 100) (NV)
\item GRL - NV range seeding (Wind C = 40) (NV)
\item GRL - NV range seeding (Wind C = 60) (NV)
\item GRL - NV range seeding (Wind C = 80) (NV)
\item GRL - NV range seeding (Wind C >= 160) (NV)
\item GRL - Rangeland Planting by Mechanical Seeding (TX)
\item GRL - Rangeland Root Plowing (TX)
\item Hybrid Wine Grape Varieties Site Desirability (Long)
\item Low Pressure Pipe Septic System (DE)
\item MIL - Bivouac Areas (DOD)
\item MIL - Excavations Crew-Served Weapon Fighting Position (DOD)
\item MIL - Excavations for Individual Fighting Position (DOD)
\item MIL - Trafficability Veh. Type 1 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 2 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 4 1-pass wet season (DOD)
\item MIL - Trafficability Veh. Type 4 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 6 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 7 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 7 dry season (DOD)
\item NCCPI - Irrigated National Commodity Crop Productivity Index
\item Nitrogen Loss Potential (ND)
\item Potential Windthrow Hazard (TN)
\item REC - Foot and ATV Trails (AK)
\item REC - Playgrounds (AK)
\item Reclamation Suitability (ND)
\item RSK-risk assessment for manure application (OH)
\item SAS - CMECS Substrate Origin
\item SAS - CMECS Substrate Subclass/Group/Subgroup
\item SAS - Mooring Anchor - Deadweight
\item Septic System A/B Soil System (Alternate) (PA)
\item Septic System CO-OP RFS III w/Spray Irrigation (PA)
\item Septic System Dual Field Trench (conventional) (WV)
\item Septic System Elevated Field (alternative) (WV)
\item Septic System In Ground Trench (conventional) (PA)
\item Septic System In Ground Trench (conventional) (WV)
\item AGR - Filter Strips (TX)
\item AGR - Hops Site Suitability (ID)
\item AGR - Mulch Till (TX)
\item AGR - Nitrate Leaching Potential, Nonirrigated (MT)
\item AGR - Nitrate Leaching Potential, Nonirrigated (WV)
\item AGR - No Till (VT)
\item AGR - Oats Yield (MT)
\item AGR - Pesticide Loss Potential-Leaching
\item AGR - Pesticide Loss Potential-Leaching (NE)
\item AGR - Rutting Hazard =< 10,000 Pounds per Wheel (TX)
\item AGR - S. Highbush Blueberry Suitability MLRA 153 (SC)
\item AGR - Wind Erosion Potential (NE)
\item AGR-Available Water Capacity (ND)
\item AGR-Physical Limitations (ND)
\item AGR-Sodicity (ND)
\item AGR-Surface Crusting (ND)
\item AGR-Wind Erosion (ND)
\item AWM - Irrigation Disposal of Wastewater (DE)
\item AWM - Land App of Municipal Sewage Sludge (DE)
\item AWM - Land App of Municipal Sewage Sludge (MD)
\item AWM - Land Application of Milk (CT)
\item AWM - Land Application of Municipal Biosolids, spring (OR)
\item AWM - Land Application of Municipal Sewage Sludge
\item AWM - Land Application of Municipal Sewage Sludge (OH)
\item AWM - Land Application of Municipal Sewage Sludge (VT)
\item AWM - Large Animal Disposal, Pit (MN)
\item AWM - Manure and Food Processing Waste
\item AWM - Manure and Food Processing Waste (VT)
\item AWM - Rapid Infil Disposal of Wastewater (MD)
\item AWM - Rapid Infiltration Disposal of Wastewater (VT)
\item AWM - Slow Rate Process Treatment of Wastewater (VT)
\item BLM - Chaining Suitability
\item BLM - Fugitive Dust Resistance
\item BLM - Soil Restoration Potential
\item BLM - Yellow Star-thistle Invasion Susceptibility
\item CLASS RULE - Depth to non-lithic bedrock (5 classes) (NPS)
\item CLR-cropland limitation for corn and soybeans (IN)
\item Commodity Crop Productivity Index (Corn) (WI)
\item CPI - Grass Hay, NIRR - Klamath Valleys and Basins (OR)
\item CPI - Potatoes Productivity Index (AK)
\item CPI - Potatoes, IRR - Eastern Idaho Plateaus (ID)
\item CPI - Small Grains, NIRR - Palouse Prairies (ID)
\item DHS - Emergency Animal Mortality Disposal by Shallow Burial
\item DHS - Rubble and Debris Disposal, Large-Scale Event
\item ENG - Aquifer Assessment - 7081 (MN)
\item ENG - Construction Materials - Gravel Source (MN)
\item ENG - Construction Materials; Gravel Source (MI)
\item ENG - Construction Materials; Gravel Source (OR)
\item ENG - Construction Materials; Reclamation
\item ENG - Construction Materials; Reclamation (OH)
\item ENG - Construction Materials; Sand Source
\item ENG - Construction Materials; Sand Source (AK)
\item ENG - Construction Materials; Sand Source (ID)
\item ENG - Construction Materials; Sand Source (IN)
\item ENG - Construction Materials; Sand Source (OH)
\item ENG - Construction Materials; Topsoil
\item ENG - Construction Materials; Topsoil (WA)
\item ENG - Ground-based Solar Arrays, Soil-based Anchor Systems
\item ENG - Local Roads and Streets
\item ENG - New Ohio Septic Rating (OH)
\item ENG - Sanitary Landfill (Trench) (OH)
\item ENG - Septic Tank Absorption Fields (AK)
\item ENG - Septic Tank Absorption Fields (DE)
\item ENG - Septic Tank Absorption Fields (NY)
\item ENG - Sewage Lagoons (OH)
\item ENG - Shallow Excavations (AK)
\item ENG - Shallow Excavations (MI)
\item ENG - Unpaved Local Roads and Streets
\item FOR - Black Walnut Suitability Index (MO)
\item FOR - Conservation Tree and Shrub Groups (TX)
\item FOR - Construction Limitations - Haul Roads/Log Landing (OH)
\item FOR - Construction Limitations For Haul Roads (MI)
\item FOR - Hand Planting Suitability (ME)
\item FOR - Harvest Equipment Operability (MD)
\item FOR - Harvest Equipment Operability (OH)
\item FOR - Harvest Equipment Operability (VT)
\item FOR - Mechanical Planting Suitability
\item FOR - Mechanical Planting Suitability (ME)
\item FOR - Mechanical Planting Suitability, MO13 (DE)
\item FOR - Potential Erosion Hazard (Off-Road/Off-Trail)
\item FOR - Potential Erosion Hazard (Road/Trail) (PIA)
\item FOR - Potential Seedling Mortality (VT)
\item FOR - Potential Windthrow Hazard (NY)
\item FOR - Potential Windthrow Hazard (VT)
\item FOR - Puddling Potential (WA)
\item FOR - Road Suitability (Natural Surface)
\item FOR - Road Suitability (Natural Surface) (OH)
\item FOR - Road Suitability (Natural Surface) (OR)
\item FOR - Rutting Hazard by Season
\item FOR - Shortleaf pine littleleaf disease susceptibility
\item FOR - Soil Compactibility Risk
\item FOR - Soil Rutting Hazard (ME)
\item FOR - Windthrow Hazard
\item FOR-Construction Limitations for Haul Roads/Log Landings(ME)
\item FOTG - Indiana Slippage Potential (IN)
\item Gravity Full Depth Septic System (DE)
\item GRL - Fencing, Post Depth =<36 inches
\item GRL - NV range seeding (Wind C = 50) (NV)
\item GRL - Ranch Access Roads (TX)
\item GRL - Rangeland Roller Chopping (TX)
\item Ground Penetrating Radar Penetration
\item Ground-based Solar Arrays_bedrock(ME)
\item Ground-based Solar Arrays_bedrock_slope_ballast(ME)
\item Hybrid Wine Grape Varieties Site Desirability (Short)
\item ISDH Septic Tank Interpretation (IN)
\item Land Application of Municipal Sewage Sludge (PA)
\item MIL - Helicopter Landing Zones (DOD)
\item MIL - Trafficability Veh. Type 2 1-pass wet season (DOD)
\item MIL - Trafficability Veh. Type 5 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 5 dry season (DOD)
\item MIL - Trafficability Veh. Type 7 1-pass wet season (DOD)
\item NCCPI - National Commodity Crop Productivity Index (Ver 3.0)
\item REC - Camp and Picnic Areas (AK)
\item REC - Picnic Areas (CT)
\item REC - Playgrounds (CT)
\item SAS - CMECS Substrate Subclass
\item Septic System Drip Irrigation (Alternate) (PA)
\item Septic System Free Access Sand Filter w/Drip Irrigation (PA)
\item Septic System In Ground Bed (conventional) (PA)
\item Septic System Peat Based Option1 (UV & At-Grade Bed)Alt (PA)
\item Septic System Peat Sys Opt3 w/Subsurface Sand Filter (PA)
\item Septic System Sand Mound Bed or Trench (PA)
\item Septic System Shallow Placement Pressure Dosed (Alt.) (PA)
\item SOH - Aggregate Stability (ND)
\item SOH - Agricultural Organic Soil Subsidence
\item SOH - Dynamic Soil Properties Response to Biochar
\item SOH - Organic Matter Depletion
\item SOIL HEALTH ASSESSMENT (NJ)
\item URB - Commercial Brick Bldg; w/Reinforced Concrete Slab (TX)
\item URB - Reinforced Concrete Slab (TX)
\item URB/REC - Camp Areas
\item URB/REC - Camp Areas (OH)
\item URB/REC - Off-Road Motorcycle Trails (OH)
\item URB/REC - Paths and Trails (OH)
\item URB/REC - Picnic Areas
\item URB/REC - Playgrounds
\item URB/REC - Playgrounds (GA)
\item Vinifera Wine Grape Site Desirability (Short to Medium)
\item WLF - Irr. Domestic Grasses & Legumes for Food & Cover (TX)
\item WLF - Upland Coniferous Trees (TX)
\item WLF - Upland Deciduous Trees (TX)
\item WLF - Upland Desertic Shrubs & Trees (TX)
\item WLF - Upland Native Herbaceous Plants (TX)
\item WLF - Upland Shrubs & Vines (TX)
\item WLF-Soil Suitability - Karner Blue Butterfly (WI)
\item WMS - Drainage (IL)
\item WMS - Drainage - (MI)
\item WMS - Embankments, Dikes, and Levees
\item WMS - Embankments, Dikes, and Levees (OH)
\item WMS - Grassed Waterways - (MI)
\item AGR - Air Quality; PM10 (TX)
\item AGR - Air Quality; PM2_5 (TX)
\item AGR - Aronia Berry Suitability (SD)
\item AGR - Farmland of Statewide Importance (TX)
\item AGR - Index for alfalfa hay, irrigated (NV)
\item AGR - Nitrate Leaching Potential, Nonirrigated (MA)
\item AGR - Rangeland Grass/Herbaceous Productivity Index (TX)
\item AGR - Rutting Hazard > 10,000 Pounds per Wheel (TX)
\item AGR - Water Erosion Potential (TX)
\item AGR - Wine Grape Site Suitability (WA)
\item AGR-Natural Fertility (ND)
\item AGR-Subsurface Salinity (ND)
\item AWM - Filter Group (OH)
\item AWM - Irrigation Disposal of Wastewater
\item AWM - Land Application of Dry and Slurry Manure (TX)
\item AWM - Land Application of Municipal Biosolids, winter (OR)
\item AWM - Overland Flow Process Treatment of Wastewater
\item AWM - Rapid Infiltration Disposal of Wastewater
\item AWM - Vegetated Treatment Area (PIA)
\item AWM - Waste Field Storage Area (VT)
\item BLM - Mechanical Treatment, Shredder
\item BLM - Medusahead Invasion Susceptibility
\item BLM - Soil Compaction Resistance
\item Capping Fill Gravity Septic System (DE)
\item CLASS RULE - Depth to any bedrock kind (5 classes) (NPS)
\item CPI - Alfalfa Hay, IRR - Eastern Idaho Plateaus (ID)
\item CPI - Alfalfa Hay, IRR - Klamath Valley and Basins (OR)
\item CPI - Alfalfa Hay, IRR - Snake River Plains (ID)
\item CPI - Alfalfa Hay, NIRR- Eastern Idaho Plateaus (ID)
\item CPI - Grass Hay, NIRR - Palouse, Northern Rocky Mtns. (WA)
\item CPI - Small Grains Productivity Index (AK)
\item DHS - Catastrophic Event, Large Animal Mortality, Incinerate
\item DHS - Emergency Land Disposal of Milk
\item DHS - Site for Composting Facility - Subsurface
\item DHS - Suitability for Clay Liner Material
\item ENG - Cohesive Soil Liner (MN)
\item ENG - Construction Materials - Sand Source (MN)
\item ENG - Construction Materials; Gravel Source (CT)
\item ENG - Construction Materials; Gravel Source (NY)
\item ENG - Construction Materials; Reclamation (DE)
\item ENG - Construction Materials; Roadfill
\item ENG - Construction Materials; Roadfill (AK)
\item ENG - Construction Materials; Sand Source (NY)
\item ENG - Construction Materials; Sand Source (VT)
\item ENG - Construction Materials; Topsoil (AK)
\item ENG - Construction Materials; Topsoil (DE)
\item ENG - Construction Materials; Topsoil (MI)
\item ENG - Construction Materials; Topsoil (OR)
\item ENG - Conventional On-Site Septic Systems (TN)
\item ENG - Deep Infiltration Systems
\item ENG - Disposal Field Gravity (DE)
\item ENG - Dwellings With Basements (OH)
\item ENG - Ground-based Solar Arrays, Ballast Anchor Systems
\item ENG - Large Animal Disposal, Trench (CT)
\item ENG - Lawn, Landscape, Golf Fairway (MI)
\item ENG - Lawn, Landscape, Golf Fairway (VT)
\item ENG - Sanitary Landfill (Area) (OH)
\item ENG - Sanitary Landfill (Trench)
\item ENG - Sanitary Landfill (Trench) (AK)
\item ENG - Septage Application - Surface (MN)
\item ENG - Septic Tank Absorption Fields - At-Grade (MN)
\item ENG - Septic Tank Absorption Fields - Mound (MN)
\item ENG - Septic Tank Leaching Chamber (TX)
\item ENG - Septic Tank, Subsurface Drip Irrigation (TX)
\item ENG - Shallow Excavations
\item ENG - Shallow Infiltration Systems
\item ENG - Small Commercial Buildings
\item ENG - Soil Potential of Road Salt Applications (CT)
\item ENG - Source of Caliche (TX)
\item ENG - Stormwater Management / Ponds (NY)
\item ENG - Unlined Retention Systems
\item Farm and Garden Composting Facility - Surface
\item FOR - Biomass Harvest (MA)
\item FOR - Black Walnut Suitability Index (KS)
\item FOR - Displacement Potential (WA)
\item FOR - Drought Vulnerable Soils
\item FOR - General Harvest Season (ME)
\item FOR - Harvest Equipment Operability
\item FOR - Mechanical Site Preparation (Deep) (MD)
\item FOR - Mechanical Site Preparation (Surface)
\item FOR - Mechanical Site Preparation; Deep (CT)
\item FOR - Potential Erosion Hazard (Road/Trail)
\item FOR - Potential Fire Damage Hazard
\item FOR - Potential Seedling Mortality
\item FOR - Potential Seedling Mortality (MI)
\item FOR - Potential Windthrow Hazard (ME)
\item FOR - Potential Windthrow Hazard (MI)
\item FOR - Road Suitability (Natural Surface) (ID)
\item FOR - Rutting Hazard by Month
\item FOR - Windthrow Hazard (WA)
\item FOTG - NLI Interp Calculation - (IN)
\item Fragile Soil Index
\item GRL - Juniper Encroachment Potential (NM)
\item GRL - NV range seeding (Wind C = 20) (NV)
\item GRL - Pasture and Hayland SG (OH)
\item GRL - Rangeland Prescribed Burning (TX)
\item GRL - Rangeland Soil Seed Bank Suitability (NM)
\item GRL-FSG-NP-W (MT)
\item GRL-SHSI Soil Health Sustainability Index (MT)
\item Ground-based Solar Arrays_saturationt(ME)
\item Ground-based Solar Arrays_slope(ME)
\item Inland Wetlands (CT)
\item IRR-restrictive features for irrigation (OH)
\item MIL - Excavations for Vehicle Fighting Position (DOD)
\item MIL - Trafficability Veh. Type 1 1-pass wet season (DOD)
\item MIL - Trafficability Veh. Type 2 dry season (DOD)
\item MIL - Trafficability Veh. Type 3 50-passes wet season (DOD)
\item MIL - Trafficability Veh. Type 6 1-pass wet season (DOD)
\item MIL - Trafficability Veh. Type 6 dry season (DOD)
\item Muscadine Wine Grape Site Desirability (Very Long)
\item NCCPI - NCCPI Cotton Submodel (II)
\item Permafrost Sensitivity (AK)
\item Pressure Dose Capping Fill Septic System (DE)
\item REC - Camp Areas (CT)
\item REC - Off-Road Motorcycle Trails (CT)
\item SAS - CMECS Substrate Class
\item SAS - CMECS Substrate Subclass/Group
\item SAS - Eelgrass Restoration Suitability
\item SAS - Land Utilization of Dredged Materials
\item SAS - Northern Quahog (Hard Clam) Habitat Suitability
\item Septic System At Grade Shallow Field (alternative) (WV)
\item Septic System At-Grade Bed (Alternate) (PA)
\item Septic System CO-OP RFS III w/Drip Irrigation (PA)
\item Septic System Drip Irrigation (alternative) (WV)
\item Septic System Free Access Sand Filterw/Spray Irrigation (PA)
\item Septic System Peat Based Option1 w/At-Grade Bed (Alt.) (PA)
\item Septic System Spray Irrigation (PA)
\item Septic System Steep Slope Sand Mound (Alternate) (PA)
\item Shallow Infiltration Systems
\item SOH - Organic Matter Depletion Potential, Irrigated (CA)
\item SOH - Soil Surface Sealing
\item TROP - Plantains Productivity
\item URB/REC - Camp Areas (GA)
\item URB/REC - Camp Areas (MI)
\item URB/REC - Golf Fairways (OH)
\item URB/REC - Off-Road Motorcycle Trails
\item URB/REC - Paths and Trails (MI)
\item URB/REC - Playgrounds (OH)
\item Vinifera Wine Grape Site Desirability (Long to Medium)
\item WLF - Chufa for Turkey Forage (LA)
\item WLF - Food Plots for Upland Wildlife < 2 Acres (TX)
\item WLF - Freshwater Wetland Plants (TX)
\item WLF - Irrigated Saline Water Wetland Plants (TX)
\item WLF - Riparian Herbaceous Plants (TX)
\item WLF - Riparian Shrubs, Vines, & Trees (TX)
\item WLF - Saline Water Wetland Plants (TX)
\item WLF - Upland Mixed Deciduous & Coniferous Trees (TX)
\item WMS - Constructing Grassed Waterways (TX)
\item WMS - Constructing Terraces and Diversions (OH)
\item WMS - Embankments, Dikes, and Levees (VT)
\item WMS - Irrigation, Sprinkler (close spaced outlet drops)
\item WMS - Irrigation, Sprinkler (general)
\item WMS - Pond Reservoir Area (GA)
\item WMS-Subsurface Water Management, Installation (ND)
\item WMS-Subsurface Water Management, Outflow Quality (ND)
\item AGR - Barley Yield (MT)
\item AGR - Conventional Tillage (TX)
\item AGR - Grape non-irrigated (MO)
\item AGR - Industrial Hemp for Fiber and Seed Production
\item AGR - Nitrate Leaching Potential, Irrigated (WA)
\item AGR - Pasture hayland (MO)
\item AGR - Pesticide Loss Potential-Soil Surface Runoff
\item AGR - Prime Farmland (TX)
\item AGR - Spring Wheat Yield (MT)
\item AGR-Agronomic Concerns (ND)
\item AGR-Pesticide and Nutrient Leaching Potential, NIRR (ND)
\item AGR-Surface Salinity (ND)
\item AGR-Water Erosion Potential (ND)
\item Alaska Exempt Wetland Potential (AK)
\item American Wine Grape Varieties Site Desirability (Short)
\item AWM - Irrigation Disposal of Wastewater (MD)
\item AWM - Manure and Food Processing Waste (DE)
\item AWM - Manure Stacking - Site Evaluation (TX)
\item AWM - Phosphorus Management (TX)
\item AWM - Slow Rate Process Treatment of Wastewater
\item BLM - Pygmy Rabbit Habitat Potential
\item BLM - Rangeland Tillage
\item BLM - Site Degradation Susceptibility
\item CA Prime Farmland (CA)
\item CLASS RULE - Depth to root limiting layer (5 classes) (NPS)
\item Commodity Crop Productivity Index (Corn) (TN)
\item CPI - Alfalfa Hay, NIRR - Palouse, Northern Rocky Mtns. (ID)
\item CPI - Barley, NIRR - Eastern Idaho Plateaus (ID)
\item CPI - Grass Hay, IRR - Eastern Idaho Plateaus (ID)
\item CPI - Grass Hay, NIRR - Palouse, Northern Rocky Mtns. (ID)
\item CPI - Potatoes, IRR - Snake River Plains (ID)
\item CPI - Small Grains, NIRR - Palouse Prairies (OR)
\item CPI - Small Grains, NIRR - Palouse Prairies (WA)
\item CPI - Small Grains, NIRR - Snake River Plains (ID)
\item CPI - Wheat, NIRR - Eastern Idaho Plateaus (ID)
\item CPI - Wild Hay, NIRR - Eastern Idaho Plateaus (ID)
\item CPI - Wild Hay, NIRR - Palouse, Northern Rocky Mtns. (ID)
\item CPI - Wild Hay, NIRR - Palouse, Northern Rocky Mtns. (WA)
\item Deep Infiltration Systems
\item DHS - Site for Composting Facility - Surface
\item Elevated Sand Mound Septic System (DE)
\item ENG - Animal Disposal by Composting (Catastrophic) (WV)
\item ENG - Application of Municipal Sludge (TX)
\item ENG - Closed-Loop Horizontal Geothermal Heat Pump (CT)
\item ENG - Construction Materials; Gravel Source (IN)
\item ENG - Construction Materials; Gravel Source (NE)
\item ENG - Construction Materials; Reclamation (MD)
\item ENG - Construction Materials; Reclamation (MI)
\item ENG - Construction Materials; Roadfill (GA)
\item ENG - Construction Materials; Sand Source (CT)
\item ENG - Construction Materials; Sand Source (GA)
\item ENG - Construction Materials; Topsoil (ID)
\item ENG - Construction Materials; Topsoil (OH)
\item ENG - Daily Cover for Landfill (OH)
\item ENG - Disposal Field (NJ)
\item ENG - Disposal Field Type Inst (NJ)
\item ENG - Dwellings W/O Basements
\item ENG - Dwellings With Basements
\item ENG - Dwellings without Basements (AK)
\item ENG - Lawn and Landscape (OH)
\item ENG - Lawn, Landscape, Golf Fairway
\item ENG - Local Roads and Streets (AK)
\item ENG - Local Roads and Streets (GA)
\item ENG - On-Site Waste Water Lagoons (MO)
\item ENG - Pier Beam Building Foundations (TX)
\item ENG - Sanitary Landfill (Area)
\item ENG - Sanitary Landfill (Area) (AK)
\item ENG - Septage Application - Incorporation or Injection (MN)
\item ENG - Septic System; Disinfection, Surface Application (TX)
\item ENG - Septic Tank Absorption Fields (FL)
\item ENG - Septic Tank Absorption Fields (OH)
\item ENG - Septic Tank Absorption Fields - Trench (MN)
\item ENG - Sewage Lagoons (AK)
\item ENG - Shallow Excavations (OH)
\item ENG - Soil Suitability for SLAMM Marsh Migration (CT)
\item ENG - Stormwater Management / Infiltration (NY)
\item ENG - Stormwater Management / Wetlands (NY)
\item FOR - Black Walnut Suitability (WI)
\item FOR - Black Walnut Suitability (WV)
\item FOR - Construction Limitations for Haul Roads/Log Landings
\item FOR - Displacement Hazard
\item FOR - Harvest Equipment Operability (DE)
\item FOR - Harvest Equipment Operability (ME)
\item FOR - Harvest Equipment Operability (MI)
\item FOR - Log Landing Suitability (ID)
\item FOR - Log Landing Suitability (MI)
\item FOR - Log Landing Suitability (OR)
\item FOR - Mechanical Planting Suitability (OH)
\item FOR - Mechanical Site Preparation (Surface) (MD)
\item FOR - Mechanical Site Preparation (Surface) (OH)
\item FOR - Mechanical Site Preparation; Surface (CT)
\item FOR - Potential Erosion Hazard (Off-Road/Off-Trail) (MI)
\item FOR - Potential Erosion Hazard (Off-Road/Off-Trail) (OH)
\item FOR - Potential Seedling Mortality (FL)
\item FOR - Potential Seedling Mortality (OH)
\item FOR - Road Suitability (Natural Surface) (VT)
\item FOR - Soil Rutting Hazard
\item FOTG - Indiana Soy Bean Yield Calculation (IN)
\item FOTG - Indiana Wheat Yield Calculation (IN)
\item FOTG - NLI report Calculation - (IN)
\item GRL - Fencing, Post Depth =<24 inches
\item GRL - Fencing, Post Depth Less Than 24 inches (TX)
\item GRL - Fencing, Post Depth Less Than 36 inches (TX)
\item GRL - NV range seeding (Wind C = 10) (NV)
\item GRL - NV range seeding (Wind C = 30) (NV)
\item GRL - Rangeland Chaining (TX)
\item GRL - Rangeland Disking (TX)
\item GRL - Rangeland Dozing/Grubbing (TX)
\item GRL - Utah Juniper Encroachment Potential
\item GRL - Western Juniper Encroachment Potential (OR)
\item Ground-based Solar Arrays_bedrock_slope_anchor(ME)
\item Ground-based Solar Arrays_saturation_flooding_Frost(ME)
\item Hybrid Wine Grape Varieties Site Desirability (Medium)
\item Lined Retention Systems
\item MIL - Trafficability Veh. Type 1 dry season (DOD)
\item MIL - Trafficability Veh. Type 3 1-pass wet season (DOD)
\item MIL - Trafficability Veh. Type 3 dry season (DOD)
\item MIL - Trafficability Veh. Type 4 dry season (DOD)
\item MIL - Trafficability Veh. Type 5 1-pass wet season (DOD)
\item NCCPI - NCCPI Corn Submodel (I)
\item NCCPI - NCCPI Small Grains Submodel (II)
\item NCCPI - NCCPI Soybeans Submodel (I)
\item Peony Flowers Site Suitability (AK)
\item Pressure Dose Full Depth Septic System (DE)
\item REC - Camp Areas; Primitive (AK)
\item REC - Paths and Trails (CT)
\item Salinity Risk Index (ND)
\item SAS - Eastern Oyster Habitat Restoration Suitability
\item SAS - Mooring Anchor - Mushroom
\item Septic System CO-OP RFS III w/At-Grade Bed (PA)
\item Septic System Free Access Sand Filter w/At-Grade Bed (PA)
\item Septic System Modified Subsurface Sand Filter (Alt.) (PA)
\item Septic System Shallow In Ground Trench (conventional) (WV)
\item Septic System Subsurface Sand Filter Bed (conventional) (PA)
\item Septic System Subsurface Sand Filter Trench (standard) (PA)
\item SOH - Limitations for Aerobic Soil Organisms
\item URB - Concrete Driveways and Sidewalks (TX)
\item URB - Dwellings on Concrete Slab (TX)
\item URB - Lawns and Ornamental Plantings (TX)
\item URB/REC - Paths and Trails
\item URB/REC - Paths and Trails (GA)
\item URB/REC - Playgrounds (MI)
\item Vinifera Wine Grape Site Desirability (Long)
\item WLF - Crawfish Aquaculture (TX)
\item WLF - Desertic Herbaceous Plants (TX)
\item WLF - Gopher Tortoise Burrowing Suitability
\item WLF - Grain & Seed Crops for Food and Cover (TX)
\item WMS - Constructing Grassed Waterways (OH)
\item WMS - Irrigation, Surface (graded)
\item WMS - Subsurface Drains - Installation (VT)
\item WMS - Subsurface Water Management, System Performance
\item WMS - Surface Drains (TX)
\item WMS - Surface Irrigation Intake Family (TX)
\item Septic System Low Pressure Pipe (alternative) (WV)
\item Septic System Mound (alternative) (WV)
\item Septic System Peat Based Option2 w/Spray Irrigation (PA)
\item Septic System Steep Slope Mound (alternative) (WV)
\item SOH - Concentration of Salts- Soil Surface
\item SOH - Soil Susceptibility to Compaction
\item Soil Habitat for Saprophyte Stage of Coccidioides
\item Unlined Retention Systems
\item URB - Commercial Metal Bldg; w/Reinforced Concrete Slab (TX)
\item URB/REC - Picnic Areas (GA)
\item URB/REC - Picnic Areas (MI)
\item URB/REC - Picnic Areas (OH)
\item Vinifera Wine Grape Site Desirability (Short)
\item WLF - Burrowing Mammals & Reptiles (TX)
\item WLF - Desert Tortoise (CA)
\item WLF - Domestic Grasses & Legumes for Food and Cover (TX)
\item WLF - Irrigated Grain & Seed Crops for Food & Cover (TX)
\item WMS - Excavated Ponds (Aquifer-fed)
\item WMS - Excavated Ponds (Aquifer-fed) (VT)
\item WMS - Irrigation, General
\item WMS - Irrigation, Micro (above ground)
\item WMS - Irrigation, Micro (above ground) (VT)
\item WMS - Irrigation, Micro (subsurface drip)
\item WMS - Irrigation, Sprinkler (general) (VT)
\item WMS - Pond Reservoir Area
\item WMS - Pond Reservoir Area (OH)
\item WMS - Subsurface Water Management, System Installation
\item WMS - Constructing Terraces & Diversions (TX)
\item WMS - Drainage (OH)
\item WMS - Excavated Ponds (Aquifer-fed) (OH)
\item WMS - Grape Production with Drip Irrigation (TX)
\item WMS - Irrigation, Micro (subsurface drip) (VT)
\item WMS - Irrigation, Surface (level)
\item WMS - Pond Reservoir Area (MI)
\item WMS - Pond Reservoir Area (VT)
\item WMS - Sprinkler Irrigation (MT)
\item WMS - Sprinkler Irrigation RDC (IL)
\item WMS - Subsurface Drains - Performance (VT)
\item WMS - Subsurface Water Management, Outflow Quality
\item WMS - Surface Water Management, System
\item WMS-Subsurface Water Management, Performance (ND)
}
}
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontshow{\}) # examplesIf}
\donttest{
  # get two forestry interpretations for CA630
  get_SDA_interpretation(c("FOR - Potential Seedling Mortality",
                           "FOR - Road Suitability (Natural Surface)"),
                         method = "Dominant Condition",
                         areasymbols = "CA630")
}
}
\author{
Jason Nemecek, Chad Ferguson, Andrew Brown
}
