% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSSURGO.R
\name{downloadSSURGO}
\alias{downloadSSURGO}
\title{Get SSURGO ZIP files from Web Soil Survey 'Download Soils Data'}
\usage{
downloadSSURGO(
  WHERE = NULL,
  areasymbols = NULL,
  destdir = tempdir(),
  exdir = destdir,
  include_template = FALSE,
  db = c("SSURGO", "STATSGO"),
  extract = TRUE,
  remove_zip = FALSE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{WHERE}{A SQL \code{WHERE} clause expression used to filter records in \code{sacatalog} table. Alternately \code{WHERE} can be any spatial object supported by \code{SDA_spatialQuery()} for defining the target extent.}

\item{areasymbols}{Character vector of soil survey area symbols e.g. \code{c("CA067", "CA077")}. Used in lieu of \code{WHERE} argument.}

\item{destdir}{Directory to download ZIP files into. Default \code{tempdir()}.}

\item{exdir}{Directory to extract ZIP archives into. May be a directory that does not yet exist. Each ZIP file will extract to a folder labeled with \code{areasymbol} in this directory. Default: \code{destdir}}

\item{include_template}{Include the (possibly state-specific) MS Access template database? Default: \code{FALSE}}

\item{db}{Either \code{"SSURGO"} (default; detailed soil map) or \code{"STATSGO"} (general soil map).}

\item{extract}{Logical. Extract ZIP files to \code{exdir}? Default: \code{TRUE}}

\item{remove_zip}{Logical. Remove ZIP files after extracting? Default: \code{FALSE}}

\item{overwrite}{Logical. Overwrite by re-extracting if directory already exists? Default: \code{FALSE}}

\item{quiet}{Logical. Passed to \code{curl::curl_download()}.}
}
\value{
Character. Paths to downloaded ZIP files (invisibly). May not exist if \code{remove_zip = TRUE}.
}
\description{
Download ZIP files containing spatial (ESRI shapefile) and tabular (TXT) files with standard SSURGO format; optionally including the corresponding SSURGO Template Database with \code{include_template=TRUE}.
}
\details{
To specify the Soil Survey Areas you would like to obtain data you use a \code{WHERE} clause for query of \code{sacatalog} table such as \code{areasymbol = 'CA067'}, \code{"areasymbol IN ('CA628', 'CA067')"} or  \verb{areasymbol LIKE 'CT\%'}.

When \code{db="STATSGO"} the \code{WHERE} argument is not supported. Allowed \code{areasymbols} include \code{"US"} and two-letter state codes e.g. \code{"WY"} for the Wyoming general soils map.

Pipe-delimited TXT files are found in \emph{/tabular/} folder extracted from a SSURGO ZIP. The files are named for tables in the SSURGO schema. There is no header / the files do not have column names. See the \emph{Soil Data Access Tables and Columns Report}: \url{https://sdmdataaccess.nrcs.usda.gov/documents/TablesAndColumnsReport.pdf} for details on tables, column names and metadata including the default sequence of columns used in TXT files. The function returns a \code{try-error} if the \code{WHERE}/\code{areasymbols} arguments result in

Several ESRI shapefiles are found in the \emph{/spatial/} folder extracted from a SSURGO ZIP. These have prefix \code{soilmu_} (mapunit), \code{soilsa_} (survey area), \code{soilsf_} (special features). There will also be a TXT file with prefix \code{soilsf_} describing any special features. Shapefile names then have an \code{a_} (polygon), \code{l_} (line), \code{p_} (point) followed by the soil survey area symbol.
}
\seealso{
\code{\link[=createSSURGO]{createSSURGO()}}
}
