% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_any_case.R
\name{to_any_case}
\alias{to_any_case}
\title{General case conversion}
\usage{
to_any_case(string, case = c("snake", "small_camel", "big_camel",
  "screaming_snake", "parsed"), preprocess = NULL, protect = NULL,
  replace_special_characters = FALSE, postprocess = NULL, prefix = "",
  postfix = "", unique_sep = NULL, empty_fill = NULL)
}
\arguments{
\item{string}{A string (for example names of a data frame).}

\item{case}{The desired target case, provided as one of \code{"snake"}, \code{"small_camel"}, \code{"big_camel"}, 
\code{"screaming_snake"} or \code{"parsed"}. The latter one is not really a case, but is helpful since it
returns the parsed input string, separated by underscores, without any further modification.}

\item{preprocess}{String that will be wrapped internally into \code{stringr::regex()}. 
All matches will be treated as additional splitting parameters besides the default ones 
(\code{"_"} and \code{" "}), when parsing the input string.}

\item{protect}{A string which is a valid \code{stringr::regex()}. Matches within the output
won't have any "_" (or artifacts of \code{preprocess}) beside. Note that \code{preprocess} has a higher precedence than protect, 
which means that it doesn't make sense to protect sth. which is already replaced
via \code{preprocess}.}

\item{replace_special_characters}{Logical, if \code{TRUE}, special characters 
will be translated to characters which are more likely to be understood by 
different programs. For example german umlauts will be translated to ae, oe, ue etc.}

\item{postprocess}{String that will be used as separator. The defaults are \code{"_"} 
and \code{""}, regarding the specified \code{case}.}

\item{prefix}{prefix (string).}

\item{postfix}{postfix (string).}

\item{unique_sep}{A string. If it is supplied, then duplicated names will get a suffix integer
in the order of their appearance. The suffix is separated by the supplied string to this argument.}

\item{empty_fill}{A string. If it is supplied, then each entry that matches "" will be replaced
by the supplied string to this argument.}
}
\value{
A character vector according the specified parameters above.
}
\description{
Function to convert strings to any case
}
\note{
\code{to_any_case()} is vectorised over \code{postprocess}, \code{prefix} and \code{postfix}.
\code{postprocess} might follow in the future.
}
\examples{
### Default usage
strings <- c("this Is a Strange_string", "AND THIS ANOTHER_One")
to_any_case(strings, case = "snake")
to_any_case(strings, case = "small_camel")
to_any_case(strings, case = "big_camel")
to_any_case(strings, case = "screaming_snake")
to_any_case(strings, case = "parsed")

### Pre -and postprocessing
strings2 <- c("this - Is_-: a Strange_string", "AND THIS ANOTHER_One")
to_snake_case(strings2)
to_any_case(strings2, case = "snake", preprocess = "-|\\\\:")

to_any_case(strings2, case = "snake", preprocess = "-|\\\\:", postprocess = " ")
to_any_case(strings2, case = "big_camel", preprocess = "-|\\\\:", postprocess = "//")

### Pre -and postfix
to_any_case(strings2, case = "big_camel", preprocess = "-|\\\\:", postprocess = "//",
            prefix = "USER://", postfix = ".exe")

### Special characters like german umlauts for example can be replaced via 
# replace_special_characters = TRUE

### Protect anything that shouldn't have an underscore beside in the output
strings3 <- c("var12", "var1.2", "va.r.1.2")
to_any_case(strings3, case = "snake")
to_any_case(strings3, case = "snake", protect = "\\\\d")
to_any_case(strings3, case = "snake", protect = "\\\\d|\\\\.")

}
\seealso{
\href{https://github.com/Tazinho/snakecase}{snakecase on github} or 
\code{\link{caseconverter}} for some handy shortcuts.
}
\author{
Malte Grosser, \email{malte.grosser@gmail.com}
}
\keyword{utilities}
