% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-package.R
\name{smooth}
\alias{smooth}
\alias{smooth-package}
\title{Smooth package}
\description{
Package contains functions implementing Single Source of Error state space models for
purposes of time series analysis and forecasting.
}
\details{
\tabular{ll}{ Package: \tab smooth\cr Type: \tab Package\cr Date: \tab
2016-01-27 - Inf\cr License: \tab GPL-2 \cr } The following functions are
included in the package:
\itemize{
\item \link[smooth]{es} - Exponential Smoothing in Single Source of Errors State Space form.
\item \link[smooth]{ces} - Complex Exponential Smoothing.
\item \link[smooth]{gum} - Generalised Exponential Smoothing.
\item \link[smooth]{ssarima} - SARIMA in state space framework.
% \item \link[smooth]{nus} - Non-Uniform Smoothing.
\item \link[smooth]{auto.ces} - Automatic selection between seasonal and non-seasonal CES.
\item \link[smooth]{auto.ssarima} - Automatic selection of ARIMA orders.
\item \link[smooth]{sma} - Simple Moving Average in state space form.
\item \link[smooth]{smoothCombine} - the function that combines forecasts from es(),
ces(), gum(), ssarima() and sma() functions.
\item \link[smooth]{cma} - Centered Moving Average. This is for smoothing time series,
not for forecasting.
\item \link[smooth]{sim.es} - simulate time series using ETS as a model.
\item \link[smooth]{sim.ces} - simulate time series using CES as a model.
\item \link[smooth]{sim.ssarima} - simulate time series using SARIMA as a model.
\item \link[smooth]{sim.gum} - simulate time series using GUM as a model.
\item \link[smooth]{sim.sma} - simulate time series using SMA.
\item \link[smooth]{sim.oes} - simulate time series based on occurrence part of ETS model.
\item \link[smooth]{oes} - occurrence part of the intermittent state space model.
}
There are also several methods implemented in the package for the classes
"smooth" and "smooth.sim":
\itemize{
\item \link[smooth]{orders} - extracts orders of the fitted model.
\item lags - extracts lags of the fitted model.
\item modelType - extracts type of the fitted model.
\item forecast - produces forecast using provided model.
\item \link[smooth]{multicov} - returns covariance matrix of multiple steps ahead forecast errors.
\item \link[smooth]{pls} - returns Prediction Likelihood Score.
\item \link[greybox]{nparam} - returns number of the estimated parameters.
\item fitted - extracts fitted values from provided model.
\item getResponse - returns actual values from the provided model.
\item residuals - extracts residuals of provided model.
\item plot - plots either states of the model or produced forecast (depending on what object
is passed).
\item simulate - uses sim functions (\link[smooth]{sim.es}, \link[smooth]{sim.ces},
\link[smooth]{sim.ssarima}, \link[smooth]{sim.gum}, \link[smooth]{sim.sma} and
\link[smooth]{sim.oes}) in order to simulate data using the provided object.
\item summary - provides summary of the object.
\item AICc, BICc - return, guess what...
}
}
\examples{

\donttest{y <- ts(rnorm(100,10,3), frequency=12)

adam(y, h=20, holdout=TRUE)
es(y, h=20, holdout=TRUE)
gum(y, h=20, holdout=TRUE)
auto.ces(y, h=20, holdout=TRUE)
auto.ssarima(y, h=20, holdout=TRUE)}

}
\references{
\itemize{
\item Snyder, R. D., 1985. Recursive Estimation of Dynamic Linear Models.
Journal of the Royal Statistical Society, Series B (Methodological) 47 (2), 272-276.
\item Hyndman, R.J., Koehler, A.B., Ord, J.K., and Snyder, R.D. (2008)
Forecasting with exponential smoothing: the state space approach,
Springer-Verlag. \doi{10.1007/978-3-540-71918-2}.
}

\itemize{
\item Svetunkov Ivan and Boylan John E. (2017). Multiplicative
State-Space Models for Intermittent Time Series. Working Paper of
Department of Management Science, Lancaster University, 2017:4 , 1-43.
\item Teunter R., Syntetos A., Babai Z. (2011). Intermittent demand:
Linking forecasting to inventory obsolescence. European Journal of
Operational Research, 214, 606-615.
\item Croston, J. (1972) Forecasting and stock control for intermittent
demands. Operational Research Quarterly, 23(3), 289-303.
\item Syntetos, A., Boylan J. (2005) The accuracy of intermittent demand
estimates. International Journal of Forecasting, 21(2), 303-314.
}

\itemize{
\item  Svetunkov, I., Kourentzes, N., & Ord, J. K. (2022).
Complex exponential smoothing. Naval Research Logistics, 69(8),
1108–1123. https://doi.org/10.1002/nav.22074
}

\itemize{
\item Svetunkov I. (2023) Smooth forecasting with the smooth package in R. arXiv:2301.01790.
\doi{10.48550/arXiv.2301.01790}.
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://openforecast.org/category/r-en/smooth/}.
}

\itemize{
\item Kolassa, S. (2011) Combining exponential smoothing forecasts using Akaike
weights. International Journal of Forecasting, 27, pp 238 - 251.
}

\itemize{
\item Taylor, J.W. and Bunn, D.W. (1999) A Quantile Regression Approach to
Generating Prediction Intervals. Management Science, Vol 45, No 2, pp
225-237.
\item Lichtendahl Kenneth C., Jr., Grushka-Cockayne Yael, Winkler
Robert L., (2013) Is It Better to Average Probabilities or
Quantiles? Management Science 59(7):1594-1611. DOI:
\doi{10.1287/mnsc.1120.1667}
}
}
\seealso{
\code{\link[greybox]{forecast}, \link[smooth]{es},
\link[smooth]{ssarima}, \link[smooth]{ces}, \link[smooth]{gum}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
