% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_weights.R
\name{show_weights}
\alias{show_weights}
\title{Search for and Validate Weights Columns in an SSN Object}
\usage{
show_weights(SSNobject, adjacency, netID = 1)
}
\arguments{
\item{SSNobject}{\code{SpatialStreamNetwork} containing data to be searched for valid network weights
for the smooth, default is 10.  For 2d (and higher) smooths, this is the marginal
basis size.}

\item{adjacency}{adjacency object corresponding to \code{SSNobject}, resulting from a call to \code{get_adjacency()}.}

\item{netID}{Positive integer indicating the network number to investigate, if multiple networks are contained in \code{SSNobject}.  Default is 1.

@return Prints the names of valid weight variables to the console.}
}
\description{
Explore SSN objects for valid stream weights for use in fitting stream network models.
}
\seealso{
\code{\link[=smnet]{smnet}}, \code{\link{plot.smnet}}, \code{\link{predict.smnet}}
}
\author{
Alastair Rushworth
}
