% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GridData.R
\name{randGrid}
\alias{randGrid}
\title{Random drawing of a \code{Grid} object}
\usage{
randGrid(dim = 1L + rpois(1L, lambda = 3), nxMin = 1L, nxE = 4L, nlevels,
  dimNames)
}
\arguments{
\item{dim}{The spatial dimension.}

\item{nxMin}{Minimum number of nodes. Integer vector of length 1
or \code{dim}.example(Grid).}

\item{nxE}{Expected number of nodes. Numeric vector of length 1
or \code{dim}.}

\item{nlevels}{Integer vector giving the number of levels for each
spatial dimension.}

\item{dimNames}{Names of the spatial dimensions.}
}
\value{
An object with S4 class \code{"Grid"}.
}
\description{
Random drawing of a \code{Grid} object
}
\details{
The nodes are drawn by first choosing their number for each
spatial dimension using a Poisson distribution, and then by
drawing a sample of the uniform distribution with the suitable
size.
}
\note{
This function is \emph{not} not for drawing random design
points from within the object.
}
\examples{
set.seed(1234)
## specify dim: number of levels are random!
GD <- randGrid(dim = 4)
plot(GD)
## specify number of levels (hence dim)
GD2 <- randGrid(nlevels = c(2, 3, 4))
plot(GD2)
}
\author{
Yves Deville
}
\seealso{
\code{\link{Grid-class}}.
}

