% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_sim.R
\name{scan_sim}
\alias{scan_sim}
\title{Perform \code{scan.test} on simulated data}
\usage{
scan_sim(
  nsim = 1,
  nn,
  ty,
  ex,
  type = "poisson",
  ein = NULL,
  eout = NULL,
  tpop = NULL,
  popin = NULL,
  popout = NULL,
  cl = NULL,
  simdist = "multinomial",
  pop = NULL,
  min.cases = 2
)
}
\arguments{
\item{nsim}{A positive integer indicating the number of
simulations to perform.}

\item{nn}{A list of nearest neighbors produced by \code{\link{nnpop}}.}

\item{ty}{The total number of cases in the study area.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{ein}{The expected number of cases in the zone.
Conventionally, this is the estimated overall disease
risk across the study area, multiplied by the total
population size of the zone.}

\item{eout}{The expected number of cases outside the
zone.  This should be \code{ty - ein} and is computed
automatically if not provided.}

\item{tpop}{The total population in the study area.}

\item{popin}{The total population in the zone.}

\item{popout}{The population outside the zone.  This
should be \code{tpop - popin} and is computed
automatically if not provided.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{simdist}{Character string indicating the simulation
distribution. The default is \code{"multinomial"}, which
conditions on the total number of cases observed. The
other options are \code{"poisson"} and \code{"binomial"}}

\item{pop}{The population size associated with each
region.}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}
}
\value{
A vector with the maximum test statistic for each
  simulated data set.
}
\description{
\code{scan.sim} efficiently performs
\code{\link{scan.test}} on a simulated data set.  The
function is meant to be used internally by the
\code{\link{scan.test}} function, but is informative for
better understanding the implementation of the test.
}
\examples{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
d <- sp::spDists(as.matrix(coords), longlat = TRUE)
nn <- scan.nn(d, pop = nydf$pop, ubpop = 0.1)
cases <- floor(nydf$cases)
ty <- sum(cases)
ex <- ty / sum(nydf$pop) * nydf$pop
yin <- nn.cumsum(nn, cases)
ein <- nn.cumsum(nn, ex)
tsim <- scan.sim(nsim = 1, nn, ty, ex, ein = ein, eout = sum(ex) - ein)
tsim <- scan_sim(nsim = 1, nn, ty, ex, ein = ein, eout = sum(ex) - ein)
}
