% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute-sample-size.R
\name{computeSampleSize}
\alias{computeSampleSize}
\title{Compute the Sample Size for a SMART.}
\usage{
computeSampleSize(V, Delta, min_Delta, alpha = 0.05, desired_power)
}
\arguments{
\item{V}{The covariance matrix of mean EDTR estimators.}

\item{Delta}{The vector of effect sizes with the first zero indicating the best EDTR.}

\item{min_Delta}{The minimum desired detectable effect size.}

\item{alpha}{The Type I error rate for not including the true best EDTR.}

\item{desired_power}{The desired power.}
}
\value{
The minimum sample size in order to achieve a power of desired_power to exclude EDTRs
from the set of best which are inferior to the optimal EDTR by min_Delta or more.
}
\description{
Computes the necessary sample size to enroll
in an arbitrary SMART design for a specified power with the goal of determining optimal
embedded dynamic treatment regime (EDTR). The power is the
probability of excluding from the set of best EDTRs all EDTRs inferior to the best
by min_Delta or more.
}
\details{
The true best EDTR is included in the set of best with probability
at least 1-alpha. Multiple comparisons are adjusted for using the
Multiple Comparison with the Best methodology.
}
\examples{
  \donttest{
  V <- rbind(c(1, 0.3, 0.3, 0.3),
             c(0.3, 1, 0.3, 0.3),
             c(0.3, 0.3, 1, 0.3),
             c(0.3, 0.3, 0.3, 1))

  #Compute sample size to achieve power of 80\% to exclude EDTRs inferior
  #to the best by 0.3 or more. The first DTR is best and the other
  #three are inferior by 0.2, 0.6, and 0.3
  #The best EDTR is included with probability greater than or equal to 95\%.
  computeSampleSize(V,
                    Delta = c(0, 0.2, 0.6, 0.3),
                    min_Delta = 0.3,
                    alpha = 0.05,
                    desired_power = 0.8)
  }
}
\seealso{
\code{\link{computePower}}
}
