% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{postMui}
\alias{postMui}
\title{Sample a value from the full conditional posterior of mu_i}
\usage{
postMui(yij, cij, taui, xib, rho)
}
\arguments{
\item{yij}{Numeric vector, cycle lengths for a single individual}

\item{cij}{Positive Integer vector, a sampled vector of length(yij) where the corresponding
values in cij indicate a sampled number of TRUE cycles in each cycle length given by yij}

\item{taui}{Numeric > 0, A sampled precision for the yijs}

\item{xib}{Numeric, result of multiplying x_i^T \%*\% beta (single value, not vector)}

\item{rho}{Numeric > 0, sampled prior precision of mu_i}
}
\value{
Numeric vector, repeated sampled value of length(yij)
}
\description{
In our model the data are drawn from LogN(mu_i + log(c_ij), tau_i). The prior for mu_i
is given as N(x_i^T \%*\% beta, rho). This function draws from the conditional posterior of mu_i.
}
\details{
Additionally, note that in order to vectorize the remainder of the MCMC algorithm
this function returns the sampled value repeated for length(yij)
}
