% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cook_weisberg.R
\name{cook_weisberg}
\alias{cook_weisberg}
\title{Cook-Weisberg Score Test for Heteroskedasticity in a Linear Regression Model}
\usage{
cook_weisberg(mainlm, auxdesign = NULL, errorfun = "additive")
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} "lm", or a list
of two components: a response vector and a design matrix (in that order).
If the latter, the design matrix must begin with a column of 1s if an
intercept is to be included in the linear model. Passing an object of
class "lm" is recommended in applications; passing a list containing
the data is recommended where optimising computational performance is
important.}

\item{auxdesign}{A \code{\link[base]{data.frame}} or
\code{\link[base]{matrix}} representing an auxiliary design matrix of
containing exogenous variables that (under alternative hypothesis) are
related to error variance, or a character "fitted.values" indicating
that the fitted \eqn{\hat{y}_i} values from OLS should be used.
If set to \code{NULL} (the default), the
design matrix of the original regression model is used. An intercept
is included in the auxiliary regression even if the first column of
\code{auxdesign} is not a vector of ones.}

\item{errorfun}{A character describing the functional form of
the error variance under the heteroskedastic alternative. Possible values
are \code{"additive"} (the default) and
\code{"multiplicative"}, corresponding to the two cases considered in
\insertCite{Cook83;textual}{skedastic}, or the name of a function in the
environment (passed as a character). If the name of a function, it
will be applied to auxiliary design element \eqn{z_{ij}} to obtain the
corresponding element of \eqn{D}, according to the notation used in
\insertCite{Cook83;textual}{skedastic}. The value \code{"additive"}
corresponds to the function \code{identity} and \code{"multiplicative"}
to the function \code{log}. Partial matching is NOT used.}
}
\value{
An object of \code{\link[base]{class}} "htest". If object is not
   assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the score test of
   \insertCite{Cook83;textual}{skedastic} for testing for heteroskedasticity
   in a linear regression model.
}
\details{
The Cook-Weisberg Score Test entails fitting an auxiliary regression model
in which the response variable is the vector of standardised squared
residuals \eqn{e_i^2/\hat{\sigma}^2} from the original OLS
model and the design matrix is some function of \eqn{Z}, an
\eqn{n \times q} matrix consisting of \eqn{q} exogenous variables.
The test statistic is half the residual sum of squares from this auxiliary
regression. Under the null hypothesis of homoskedasticity, the distribution
of the test statistic is asymptotically chi-squared with \eqn{q} degrees of
freedom. The test is right-tailed.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
cook_weisberg(mtcars_lm)
cook_weisberg(mtcars_lm, auxdesign = "fitted.values", errorfun = "multiplicative")

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link[car:ncvTest]{car::ncvTest}}, which implements the same
test. Calling \code{car::ncvTest} with \code{var.formula} argument omitted
is equivalent to calling \code{skedastic::cook_weisberg} with
\code{auxdesign = "fitted.values", errorfun = "additive"}. Calling
\code{car::ncvTest} with \code{var.formula = ~ X} (where \code{X} is the
design matrix of the linear model with the intercept column omitted) is
equivalent to calling \code{skedastic::cook_weisberg} with default
\code{auxdesign} and \code{errorfun} values. The
\code{errorfun = "multiplicative"} option has no equivalent in
\code{car::ncvTest}.
}
