% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rse}
\alias{rse}
\title{Residual Standard Error (RSE)}
\usage{
rse(fit)
}
\arguments{
\item{fit}{Fitted linear model of class \code{\link{lm}} or
\code{\link[lme4]{merMod}} (\pkg{lme4}).}
}
\value{
The residual standard error of \code{fit}.
}
\description{
Compute the residual standard error of fitted linear (mixed effects) models.
}
\note{
The residual standard error is the square root of the residual
       sum of squares divided by the residual degrees of freedom.
}
\examples{
data(efc)
fit <- lm(barthtot ~ c160age + c12hour, data = efc)
rse(fit)

library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
rse(fit)

}
\seealso{
\code{\link{cv}} for the coefficient of variation, and
           \code{\link{rmse}} for the root mean squared error.
}

