% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svy_scale_weights.R
\name{scale_weights}
\alias{scale_weights}
\title{Rescale design weights for multilevel analysis}
\usage{
scale_weights(x, cluster.id, pweight)
}
\arguments{
\item{x}{A data frame.}

\item{cluster.id}{Variable indicating the grouping structure (strata) of
the survey data (level-2-cluster variable).}

\item{pweight}{Variable indicating the probability (design or sampling)
weights of the survey data (level-1-weight).}
}
\value{
\code{x}, with two new variables: \code{svywght_a} and \code{svywght_b},
   which represent the rescaled design weights to use in multilevel models.
}
\description{
Most functions to fit multilevel and mixed effects models only
   allow to specify frequency weights, but not design (i.e. sampling or probability)
   weights, which should be used when analyzing complex samples and survey data.
   \code{scale_weights()} implements an algorithm proposed by Aaparouhov (2006)
   and Carle (2009) to rescale design weights in survey data to account for
   the grouping structure of multilevel models, which then can be used for
   multilevel modelling.
}
\details{
Rescaling is based on two methods: For \code{svywght_a}, the sample
   weights \code{pweight} are adjusted by a factor that represents the proportion
   of cluster size divided by the sum of sampling weights within each cluster.
   The adjustment factor for \code{svywght_b} is the sum of sample weights
   within each cluster devided by the sum of squared sample weights within
   each cluster (see Carle (2009), Appendix B).
}
\examples{
data(nhanes_sample)
scale_weights(nhanes_sample, SDMVSTRA, WTINT2YR)

}
\references{
Carle AC. \emph{Fitting multilevel models in complex survey data with design weights: Recommendations.} BMC Medical Research Methodology 2009, 9(49): 1-13
   \cr \cr
   Aaparouhov T. \emph{General Multi-Level Modeling with Sampling Weights.} Communications in Statistics—Theory and Methods 2006, 35: 439–460
}
