% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frq.R
\name{frq}
\alias{frq}
\title{Frequencies of labelled variables}
\usage{
frq(x, ..., sort.frq = c("none", "asc", "desc"), weight.by = NULL)
}
\arguments{
\item{x}{A vector or a data frame. May also be a grouped data frame
(see 'Note' and 'Examples').}

\item{...}{Optional, unquoted names of variables that should be selected for
further processing. Required, if \code{x} is a data frame (and no
vector) and only selected variables from \code{x} should be processed.
You may also use functions like \code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{sort.frq}{Determines whether categories should be sorted
according to their frequencies or not. Default is \code{"none"}, so
categories are not sorted by frequency. Use \code{"asc"} or
\code{"desc"} for sorting categories ascending or descending order.}

\item{weight.by}{Vector of weights that will be applied to weight all observations.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}
}
\value{
A list of data frames with values, value labels, frequencies, raw, valid and
          cumulative percentages of \code{x}.
}
\description{
This function returns a frequency table of labelled vectors, as data frame.
}
\note{
\code{x} may also be a grouped data frame (see \code{\link[dplyr]{group_by}})
      with up to two grouping variables. Frequency tables are created for each
      subgroup then.
}
\examples{
library(haven)
# create labelled integer
x <- labelled(
  c(1, 2, 1, 3, 4, 1),
  c(Male = 1, Female = 2, Refused = 3, "N/A" = 4)
)
frq(x)

x <- labelled(
  c(1:3, tagged_na("a", "c", "z"), 4:1, 2:3),
  c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
    "Refused" = tagged_na("a"), "Not home" = tagged_na("z"))
)
frq(x)

# in a pipe
data(efc)
library(dplyr)
efc \%>\%
  select(e42dep, e15relat, c172code) \%>\%
  frq()

# or:
# frq(efc, e42dep, e15relat, c172code)

# with grouped data frames, in a pipe
efc \%>\%
  group_by(e16sex, c172code) \%>\%
  frq(e16sex, c172code, e42dep)

# with select-helpers: all variables from the COPE-Index
# (which all have a "cop" in their name)
frq(efc, contains("cop"))

# all variables from column "c161sex" to column "c175empl"
frq(efc, c161sex:c175empl)

}
\seealso{
\code{\link{flat_table}} for labelled (proportional) tables.
}
