% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc.R
\name{get_re_var}
\alias{get_re_var}
\title{Random effect variances}
\usage{
get_re_var(x, comp = c("tau.00", "tau.01", "tau.11", "rho.01", "sigma_2"))
}
\arguments{
\item{x}{An object of class \code{icc.lme4}, as returned by the \code{\link{icc}} function,
or a fitted mixed effects model (\code{\link[lme4]{merMod}}-class).}

\item{comp}{Name of the variance component to be returned. See 'Details'.}
}
\value{
The required variance component.
}
\description{
This function extracts specific components from the random effect
               variances or the random-intercept-slope-correlation of mixed
               effects models. Currently, only \code{\link[lme4]{merMod}} objects
               are supported.
}
\details{
The random effect variances indicate the between- and within-group
        variances as well as random-slope variance and random-slope-intercept
        correlation. Use following values for \code{comp} to get the particular
        variance component:
        \describe{
         \item{\code{"sigma_2"}}{Within-group (residual) variance}
         \item{\code{"tau.00"}}{Between-group-variance (variation between individual intercepts and average intercept)}
         \item{\code{"tau.11"}}{Random-slope-variance (variation between individual slopes and average slope)}
         \item{\code{"tau.01"}}{Random-Intercept-Slope-covariance}
         \item{\code{"rho.01"}}{Random-Intercept-Slope-correlation}
        }
}
\examples{
library(lme4)
fit <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

# icc
icc(fit)

# all random effect variance components
re_var(fit)

# just the rand. slope-intercept covariance
get_re_var(fit, "tau.01")

sleepstudy$mygrp <- sample(1:45, size = 180, replace = TRUE)
fit <- lmer(Reaction ~ Days + (1 | mygrp) + (Days | Subject), sleepstudy)
get_re_var(fit, "rho.01")

}
\seealso{
\code{\link{icc}} and \code{\link{re_var}}
}

