% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudo_r2.R
\name{pseudo_r2}
\alias{pseudo_r2}
\title{Nagelkerke's and Cox-Snell's Pseudo R-squared}
\usage{
pseudo_r2(x)
}
\arguments{
\item{x}{Fitted \code{\link{glm}} model.}
}
\value{
An object of class \code{pseudo_r2} with
          following values:
          \itemize{
           \item \code{CoxSnell} Cox-Snell's pseudo-r-squared-value
           \item \code{Nagelkerke} Nagelkerke's pseudo-r-squared-value
          }
}
\description{
This method calculates Nagelkerke's and Cox-Snell's
               pseudo-r-squared-values of generalized linear models
               for binary data.
}
\examples{
data(efc)

# Pseudo-R-squared values
efc$services <- dicho(efc$tot_sc_e, "v", 0, as.num = TRUE)
fit <- glm(services ~ neg_c_7 + c161sex + e42dep,
           data = efc,
           family = binomial(link = "logit"))
pseudo_r2(fit)

}
\seealso{
\code{\link{cod}} for Tjur's Coefficient of Discrimination.
}

