% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotFrequencies.R
\name{sjp.frq}
\alias{sjp.frq}
\title{Plot frequencies of (count) variables}
\usage{
sjp.frq(varCount, title = "", weightBy = NULL, weightByTitleString = NULL,
  interactionVar = NULL, sort.frq = "none", type = "bars",
  geom.size = NULL, geom.colors = NULL, axisLabels.x = NULL,
  interactionVarLabels = NULL, axisLimits.x = NULL, axisLimits.y = NULL,
  breakTitleAt = 50, breakLabelsAt = 20, gridBreaksAt = NULL,
  innerBoxPlotWidth = 0.15, innerBoxPlotDotSize = 3, expand.grid = FALSE,
  showValueLabels = TRUE, showCountValues = TRUE,
  showPercentageValues = TRUE, showAxisLabels.x = TRUE,
  showAxisLabels.y = TRUE, showCI = FALSE, error.bar.color = "darkred",
  showMeanIntercept = FALSE, showMeanValue = TRUE,
  showStandardDeviation = TRUE, showNormalCurve = FALSE,
  showStandardNormalCurve = FALSE, adjustNormalCurve.x = FALSE,
  meanInterceptLineType = 2, meanInterceptLineSize = 0.5,
  normalCurveColor = "red", normalCurveSize = 0.8, normalCurveAlpha = 0.4,
  axisTitle.x = NULL, axisTitle.y = NULL, startAxisAt = "auto",
  hist.skipZeros = FALSE, autoGroupAt = NULL, coord.flip = FALSE,
  labelPos = "outside", na.rm = TRUE, printPlot = TRUE)
}
\arguments{
\item{varCount}{a vector of values (variable) describing the bars which make up the plot.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_var_labels}}) for details). If \code{title = ""},
no title is printed.}

\item{weightBy}{weight factor that will be applied to weight all cases of \code{varCount}.
Must be a vector of same length as \code{varCount}. Default is \code{NULL}, so no weights are used.}

\item{weightByTitleString}{suffix (as string) for the plot's title, if \code{weightBy} is specified,
e.g. \code{weightByTitleString=" (weighted)"}. Default is \code{NULL}, so plot's
title will not have a suffix when cases are weighted.}

\item{interactionVar}{an interaction variable which can be used for box plots. Divides the observations in
\code{varCount} into sub groups indicated by \code{interactionVar}. Only
applies when \code{type = "boxplots"} or \code{"violins"}.}

\item{sort.frq}{Determines whether categories (bars) on x-axis should be sorted
according to the frequencies or not.  Default is \code{"none"}, so
categories are not sorted by frequency. Use \code{"asc"} or
\code{"desc"} for sorting categories ascending or descending order.}

\item{type}{Specifies the type of distribution plot that will be plotted.
\describe{
  \item{\code{"bars"}}{for simple bars (the default setting)}
  \item{\code{"dots"}}{for a dot plot}
  \item{\code{"histogram"}}{for a histogram}
  \item{\code{"lines"}}{for a line-styled histogram with filled area}
  \item{\code{"density"}}{for a density plot}
  \item{\code{"boxplots"}}{for box plots}
  \item{\code{"violins"}}{for violin plots}
  }
  You may use initial letter for \code{type} options, except for
  \code{type = "dots"} and \code{type = "boxplots"}, which may be abbreviated
  with \code{type = "dot"} and \code{type = "box"}}

\item{geom.size}{size resp. width of the geoms (bar width or point size, depending on \code{type} parameter).
Note that  bar and bin widths mostly need smaller values than dot sizes (i.e. if \code{type = "dots"}).
By default, \code{geom.size = NULL}, which means that this parameter is automatically
adjusted depending on the plot type.}

\item{geom.colors}{user defined color for geoms, e.g. \code{geom.colors = "#0080ff"}.}

\item{axisLabels.x}{a character vector with labels for the x-axis breaks. \strong{Note:}
Axis labels will be automatically detected, when data was either imported
with \code{\link[sjmisc]{read_spss}} or has named factor levels
(see 'Examples'). Else, specifiy parameter like this:
\code{axisLabels.x = c("Label1", "Label2", "Label3")}.
The labels may also be passed as \code{\link{list}} object. They will be coerced
to character vector automatically.}

\item{interactionVarLabels}{a character vector with labels for the x-axis breaks
when having interaction variables included. These labels replace the
\code{axisLabels.x}. Only applies, when using box or violin plots
(i.e. \code{type = "boxplots"} or \code{"violins"}) and \code{interactionVar}
is not \code{NULL}.}

\item{axisLimits.x}{numeric vector of length two, defining lower and upper axis limits
of the x scale. By default, this parameter is set to \code{NULL}, i.e. the
x-axis fits to the required range to plot all data. \strong{Note} that limiting
the x-axis-range may result in warnings from \code{ggplot} due to values
outside this range that could not be plotted.}

\item{axisLimits.y}{numeric vector of length two, defining lower and upper axis limits
of the y scale. By default, this parameter is set to \code{NULL}, i.e. the
y-axis ranges from 0 to required maximum.}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{gridBreaksAt}{set breaks for the y-axis, i.e. at every \code{gridBreaksAt}'th
position a major grid is being printed.}

\item{innerBoxPlotWidth}{width of the inner box plot that is plotted inside of violin plots. Only applies
if \code{type = "violins"}. Default value is 0.15}

\item{innerBoxPlotDotSize}{size of mean dot insie a violin or box plot. Applies only
when \code{type = "violins"} or \code{"boxplots"}.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{showValueLabels}{logical, whether count and percentage values should be plotted to each bar. Default
is \code{TRUE}.}

\item{showCountValues}{logical, if \code{TRUE} (default), count values are plotted to each bar.
If \code{FALSE}, count values are removed.}

\item{showPercentageValues}{logical, if \code{TRUE} (default), percentage values are plotted to each bar
If \code{FALSE}, percentage values are removed.}

\item{showAxisLabels.x}{logical, whether x-axis labels (category names) should be shown or not.}

\item{showAxisLabels.y}{logical, whether y-axis labels (count values) should be shown or not.}

\item{showCI}{logical, whether or not confidence intervals should be plotted.
Only applies to \code{type = "dots"} or \code{type = "bars"}.}

\item{error.bar.color}{color of confidence interval bars (error bars).
Only applies to \code{type = "bars"}. In case of dot plots, error bars
will have same colors as dots (see \code{geom.colors}).}

\item{showMeanIntercept}{logical, if \code{TRUE}, a vertical line in histograms
is drawn to indicate the mean value of the count variables. Only
applies to histogram-charts.}

\item{showMeanValue}{logical, if \code{TRUE} (default), the mean value
is printed to the vertical line that indicates the mean value
of the count variables. Only applies to histogram-charts.}

\item{showStandardDeviation}{logical, if \code{TRUE}, the standard deviation
is annotated as shaded rectangle around the mean intercept
line. Only applies to histogram-charts.}

\item{showNormalCurve}{logical, if \code{TRUE}, a normal curve, which is adjusted to the data,
is plotted over the histogram or density plot. Default is
\code{FALSE}. Only applies when histograms or density plots are plotted (see \code{type}).}

\item{showStandardNormalCurve}{logical, if \code{TRUE}, a normal curve, which is not
adjusted to the data (thus representing a "true" standard normal curve,
which is, however, still an approximation), is plotted over the histogram
or density plot. Default is \code{FALSE}. Only applies when
histograms or density plots are plotted (see \code{type}).}

\item{adjustNormalCurve.x}{logical, if \code{TRUE} and \code{showStandardNormalCurve} is also \code{TRUE}, the
x-axis-start of the standard normal curve starts with the x-axis limits of the graph. This
is only necessary, if minimum value of \code{varCount} is larger than 0 or 1.}

\item{meanInterceptLineType}{numeric value, indicating the linetype of the mean
intercept line. Only applies to histogram-charts and
when \code{showMeanIntercept = TRUE}.}

\item{meanInterceptLineSize}{numeric, size of the mean intercept line. Only
applies to histogram-charts and when \code{showMeanIntercept = TRUE}.}

\item{normalCurveColor}{color of the normal curve line. Only
applies if \code{showNormalCurve = TRUE}.}

\item{normalCurveSize}{numeric, size of the normal curve line. Only
applies if \code{showNormalCurve = TRUE}.}

\item{normalCurveAlpha}{transparancy level (alpha value) of the normal curve. Only
applies if \code{showNormalCurve = TRUE}.}

\item{axisTitle.x}{title for the x-axis. By default, the variable name will be
automatically detected and used as title (see \code{\link[sjmisc]{set_var_labels}})
for details).}

\item{axisTitle.y}{title for the y-axis. By default, this value is \code{NULL},
i.e. no title is printed.}

\item{startAxisAt}{numeric, determines the lower limit of the x-axis. By default, this value is set
to \code{"auto"}, i.e. the value range on the x-axis starts with the lowest value of \code{varCount}.
If \code{startAxisAt = 1}, plot may have zero counts if the lowest value of \code{varCount}
is larger than 1 and hence no bars plotted for these values in such cases.}

\item{hist.skipZeros}{logical, if \code{TRUE}, zero counts (categories with no answer)
in \code{varCount} are omitted when drawing histrograms, and the mapping
is changed to \code{\link[ggplot2]{stat_bin}}. Only applies to  histograms.
Use this parameter to get similar results to the default \code{\link[ggplot2]{qplot}}
or \code{\link[ggplot2]{geom_histogram}} histogram plots of ggplot. You may need
to adjust the \code{geom.size} parameter for better visual results
(which, by ggplot-default, is 1/30 of the x-axis-range).}

\item{autoGroupAt}{numeric value, indicating at which length of unique values of \code{varCount},
automatic grouping into smaller units is done (see \code{\link[sjmisc]{group_var}}).
If \code{varCount} has large numbers of unique values, there may be too many bars
for the plot. Hence it's practical to group such variables. For example,
if \code{autoGroupAt = 50} and \code{varCount} has more than 50 unique values,
it will be grouped (using the \code{\link[sjmisc]{group_var}} function).
Default value for \code{autoGroupAt} is \code{NULL}, i.e. auto-grouping is off.
See \code{\link[sjmisc]{group_var}} for examples on grouping.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{labelPos}{string, indicating the position of value labels, when \code{coord.flip = TRUE}.
         Can be either \code{"inside"} or \code{"outside"} (default). You may specify
         initial letter only. If \code{coord.flip = FALSE}, this parameter will
         be ignored.}

\item{na.rm}{logical, if \code{TRUE}, missings are not included in the frequency plot.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{mydf}).
}
\description{
Plot frequencies of a (count) variable as bar graph, histogram,
               box plot etc.
}
\note{
This function only works with variables with integer values, i.e. scales / centred variables
        with decimales may result in unexpected behaviour.
}
\examples{
# ---------------
# boxplot
# ---------------
sjp.frq(ChickWeight$weight, type = "box")

# ---------------
# histogram
# ---------------
sjp.frq(discoveries, type = "hist", showMeanIntercept = TRUE)
# histogram with minimal theme and w/o labels
sjp.frq(discoveries, type = "hist",
        showMeanIntercept = TRUE,
        showValueLabels = FALSE)

# ---------------
# violin plot
# ---------------
sjp.frq(ChickWeight$weight, type = "v")

# ---------------
# bar plot
# ---------------
sjp.frq(ChickWeight$Diet)

# ---------------
# bar plot with EUROFAMCARE sample dataset
# dataset was importet from an SPSS-file, using:
# efc <- sjmisc::read_spss("efc.sav", enc = "UTF-8")
# ---------------
library(sjmisc)
data(efc)
efc.val <- get_val_labels(efc)
efc.var <- get_var_labels(efc)
# you may use sjp.setTheme here to change axis textangle
sjp.frq(as.factor(efc$e15relat),
        title = efc.var[['e15relat']],
        axisLabels.x = efc.val['e15relat'])

# bar plot with EUROFAMCARE sample dataset
# grouped variable
ageGrp <- group_var(efc$e17age)
ageGrpLab <- group_labels(efc$e17age)
sjp.frq(ageGrp,
        title = efc.var[['e17age']],
        axisLabels.x = ageGrpLab)

# ---------------
# box plots with interaction variable
# the following example is equal to the function call
# sjp.grpfrq(efc$e17age, efc$e16sex, type = "box")
# ---------------
sjp.frq(efc$e17age,
        title = paste(efc.var[['e17age']],
                      "by",
                      efc.var[['e16sex']]),
        interactionVar = efc$e16sex,
        interactionVarLabels = efc.val['e16sex'],
        type = "box")

# -------------------------------------------------
# auto-detection of value labels and variable names
# -------------------------------------------------
# negative impact scale, ranging from 7-28, assuming that
# variable scale (lowest value) starts with 1
sjp.frq(efc$neg_c_7, startAxisAt = 1)

# negative impact scale, ranging from 7-28, using
# automatic detection of start index of x-axis
sjp.frq(efc$neg_c_7)

# -------------------------------------------------
# plotting confidence intervals
# -------------------------------------------------
sjp.frq(efc$e15relat,
        type = "dots",
        showCI = TRUE,
        sort.frq = "desc",
        coord.flip = TRUE)

# -------------------------------------------------
# Simulate ggplot-default histogram, using "hist.skipZeros"
# and adjusted "geom.size".
# -------------------------------------------------
sjp.frq(efc$c160age,
        type = "h",
        hist.skipZeros = TRUE,
        geom.size = 1)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/sjp.frq/}{sjPlot manual: sjp.frq}
           \item \code{\link{sjt.frq}}
         }
}

