% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotClusterAnalysis.R
\name{sjc.dend}
\alias{sjc.dend}
\title{Compute hierarchical cluster analysis and visualize group classification}
\usage{
sjc.dend(data, groupcount, distance = "euclidean", agglomeration = "ward")
}
\arguments{
\item{data}{data frame containing all variables that should be used for the
cluster analysis.}

\item{groupcount}{The amount of groups (clusters) that should be used.
         \itemize{
           \item Use \code{\link{sjc.elbow}}-function to determine the group-count depending on the elbow-criterion.
           \item Use \code{\link{sjc.grpdisc}}-function to inspect the goodness of grouping (accuracy of classification).
         }
         Solutions for multiple cluster groups can be plotted, for instance with \code{"groupcount = c(3:6)"}.}

\item{distance}{distance measure to be used when \code{method = "hclust"} (for hierarchical
clustering). Must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"},
\code{"canberra"}, \code{"binary"} or \code{"minkowski"}. See \code{\link{dist}}.
If is \code{method = "kmeans"} this parameter will be ignored.}

\item{agglomeration}{agglomeration method to be used when \code{method = "hclust"} (for hierarchical
clustering). This should be one of \code{"ward"}, \code{"single"}, \code{"complete"}, \code{"average"},
\code{"mcquitty"}, \code{"median"} or \code{"centroid"}. Default is \code{"ward"} (see \code{\link{hclust}}).
If \code{method = "kmeans"} this parameter will be ignored. See 'Note'.}
}
\description{
Computes a hierarchical cluster analysis and plots a hierarchical
               dendrogram with highlighted rectangles around the classified groups.
               Can be used, for instance, as visual tool to verify the elbow-criterion
               (see \code{\link{sjc.elbow}}).
}
\note{
Since R version > 3.0.3, the \code{"ward"} option has
         been replaced by either \code{"ward.D"} or \code{"ward.D2"},
         so you may use one of these values. When using \code{"ward"},
         it will be replaced by \code{"ward.D2"}.
}
\examples{
# Plot dendrogram of hierarchical clustering of mtcars-dataset
# and show group classification
sjc.dend(mtcars, 5)

# Plot dendrogram of hierarchical clustering of mtcars-dataset
# and show group classification for 2 to 4 groups
sjc.dend(mtcars, 2:4)
}

