% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sji.setVariableLabels}
\alias{sji.setVariableLabels}
\title{Set variable label(s) to a single variable or data frame}
\usage{
sji.setVariableLabels(x, lab)
}
\arguments{
\item{x}{A single variable (vector) or data frame with variables.}

\item{lab}{If \code{x} is a vector (single variable), use a single character string with
the variable label for \code{x}. If \code{x} is a \code{\link{data.frame}}, use a
vector with character labels of same length as \code{ncol(x)}.}
}
\value{
\code{x}, with attached \code{"variable.label"} attribute(s), which contains the
          variable name(s).
}
\description{
This function sets variable labels to a single variable or to
               a set of variables in a data frame. To each variable, the
               attribute \code{"variable.label"} with the related variable
               name is attached. Most of this package's functions can automatically
               retrieve the variable name to use it as axis labels or plot title.
}
\examples{
# sample data set, imported from SPSS. Variable labels are attached
# as attribute to the data frame (so variables currently don't have this attribute)
data(efc)
# get variable labels
variable.labels <- sji.getVariableLabels(efc)
# set variable labels as attribute to each single variable of data frame
efc <- sji.setVariableLabels(efc, variable.labels)

\dontrun{
sjt.frq(efc$e42dep)
sjt.frq(data.frame(efc$e42dep, efc$e16sex))}

# ---------------------------------------------
# manually set value and variable labels
# ---------------------------------------------
dummy <- sample(1:4, 40, replace=TRUE)
dummy <- sji.setValueLabels(dummy, c("very low", "low", "mid", "hi"))
dummy <- sji.setVariableLabels(dummy, "Dummy-variable")
# auto-detection of value labels by default, auto-detection of
# variable labels if parameter "title" set to "auto"
sjp.frq(dummy, title="auto")
}
\references{
\url{http://rpubs.com/sjPlot/datainit}
}
\seealso{
\link{sji.getValueLabels} \cr
         \link{sji.setValueLabels} \cr
         \link{sji.getVariableLabels} \cr
         \link{sji.SPSS} \cr
         \link{sji.convertToLabel} \cr
         \link{sji.convertToValue}
}

