% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_label_classification.R
\name{sits_label_classification}
\alias{sits_label_classification}
\alias{sits_label_classification.probs_cube}
\alias{sits_label_classification.probs_vector_cube}
\alias{sits_label_classification.raster_cube}
\alias{sits_label_classification.derived_cube}
\alias{sits_label_classification.default}
\title{Build a labelled image from a probability cube}
\usage{
sits_label_classification(cube, ...)

\method{sits_label_classification}{probs_cube}(
  cube,
  ...,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1",
  progress = TRUE
)

\method{sits_label_classification}{probs_vector_cube}(
  cube,
  ...,
  output_dir,
  version = "v1",
  progress = TRUE
)

\method{sits_label_classification}{raster_cube}(cube, ...)

\method{sits_label_classification}{derived_cube}(cube, ...)

\method{sits_label_classification}{default}(cube, ...)
}
\arguments{
\item{cube}{Classified image data cube.}

\item{...}{Other parameters for specific functions.}

\item{memsize}{maximum overall memory (in GB) to label the
classification.}

\item{multicores}{Number of workers to label the classification in
parallel.}

\item{output_dir}{Output directory for classified files.}

\item{version}{Version of resulting image
(in the case of multiple runs).}

\item{progress}{Show progress bar?}
}
\value{
A data cube with an image with the classified map.
}
\description{
Takes a set of classified raster layers with probabilities,
and labels them based on the maximum probability for each pixel.
This function is the final step of main the land classification workflow.
}
\note{
The main \code{sits} classification workflow has the following steps:
\enumerate{
     \item{\code{\link[sits]{sits_cube}}: selects a ARD image collection from
         a cloud provider.}
     \item{\code{\link[sits]{sits_cube_copy}}: copies an ARD image collection
         from a cloud provider to a local directory for faster processing.}
     \item{\code{\link[sits]{sits_regularize}}: create a regular data cube
         from an ARD image collection.}
     \item{\code{\link[sits]{sits_apply}}: create new indices by combining
         bands of a  regular data cube (optional).}
     \item{\code{\link[sits]{sits_get_data}}: extract time series
         from a regular data cube based on user-provided labelled samples.}
     \item{\code{\link[sits]{sits_train}}: train a machine learning
         model based on image time series.}
     \item{\code{\link[sits]{sits_classify}}: classify a data cube
         using a machine learning model and obtain a probability cube.}
     \item{\code{\link[sits]{sits_smooth}}: post-process a probability cube
         using a spatial smoother to remove outliers and
         increase spatial consistency.}
     \item{\code{\link[sits]{sits_label_classification}}: produce a
         classified map by selecting the label with the highest probability
         from a smoothed cube.}
}

Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube, output_dir = tempdir())
    # plot the smoothed cube
    plot(bayes_cube)
    # label the probability cube
    label_cube <- sits_label_classification(
        bayes_cube,
        output_dir = tempdir()
    )
    # plot the labelled cube
    plot(label_cube)
}
}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}

Felipe Souza, \email{felipe.souza@inpe.br}
}
