% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_classify.R
\name{sits_classify}
\alias{sits_classify}
\alias{sits_classify.tbl_df}
\alias{sits_classify.derived_cube}
\alias{sits_classify.default}
\title{Classify time series or data cubes}
\usage{
sits_classify(data, ml_model, ...)

\method{sits_classify}{tbl_df}(data, ml_model, ...)

\method{sits_classify}{derived_cube}(data, ml_model, ...)

\method{sits_classify}{default}(data, ml_model, ...)
}
\arguments{
\item{data}{Data cube (tibble of class "raster_cube")}

\item{ml_model}{R model trained by \code{\link[sits]{sits_train}}}

\item{...}{Other parameters for specific functions.}
}
\value{
Time series with predicted labels for
                          each point (tibble of class "sits")
                          or a data cube with probabilities for each class
                          (tibble of class "probs_cube").
}
\description{
This function classifies a set of time series or data cube using
a trained model prediction model created by \code{\link[sits]{sits_train}}.

The \code{sits_classify} function takes three types of data as input
   and produce there types of output. Users should call
   \code{\link[sits]{sits_classify}} but be aware that the parameters
   are different for each type of input.
\itemize{
   \item{\code{\link[sits]{sits_classify.sits}} is called when the input is
   a set of time series. The output is the same set
   with the additional column \code{predicted}.}
   \item{\code{\link[sits]{sits_classify.raster_cube}} is called when the
   input is a regular raster data cube. The output is a probability cube,
   which has the same tiles as the raster cube. Each tile contains
   a multiband image; each band contains the probability that
   each pixel belongs to a given class.
   Probability cubes are objects of class "probs_cube".}
   \item{\code{\link[sits]{sits_classify.vector_cube}} is called for
   vector data cubes. Vector data cubes are produced when
   closed regions are obtained from raster data cubes using
   \code{\link[sits]{sits_segment}}. Classification of a vector
   data cube produces a vector data structure with additional
   columns expressing the class probabilities for each object.
   Probability cubes for vector data cubes
   are objects of class "probs_vector_cube".}
   }
}
\note{
The main \code{sits} classification workflow has the following steps:
\enumerate{
     \item{\code{\link[sits]{sits_cube}}: selects a ARD image collection from
         a cloud provider.}
     \item{\code{\link[sits]{sits_cube_copy}}: copies an ARD image collection
         from a cloud provider to a local directory for faster processing.}
     \item{\code{\link[sits]{sits_regularize}}: create a regular data cube
         from an ARD image collection.}
     \item{\code{\link[sits]{sits_apply}}: create new indices by combining
         bands of a  regular data cube (optional).}
     \item{\code{\link[sits]{sits_get_data}}: extract time series
         from a regular data cube based on user-provided labelled samples.}
     \item{\code{\link[sits]{sits_train}}: train a machine learning
         model based on image time series.}
     \item{\code{\link[sits]{sits_classify}}: classify a data cube
         using a machine learning model and obtain a probability cube.}
     \item{\code{\link[sits]{sits_smooth}}: post-process a probability cube
         using a spatial smoother to remove outliers and
         increase spatial consistency.}
     \item{\code{\link[sits]{sits_label_classification}}: produce a
         classified map by selecting the label with the highest probability
         from a smoothed cube.}
}

SITS supports the following models:
\itemize{
     \item{support vector machines:  \code{\link[sits]{sits_svm}};}
     \item{random forests:  \code{\link[sits]{sits_rfor}};}
     \item{extreme gradient boosting: \code{\link[sits]{sits_xgboost}};}
     \item{multi-layer perceptrons: \code{\link[sits]{sits_mlp}};}
     \item{temporal CNN: \code{\link[sits]{sits_tempcnn}};}
     \item{temporal self-attention encoders:
        \code{\link[sits]{sits_lighttae}} and
        \code{\link[sits]{sits_tae}}.}
}

   Please refer to the sits documentation available in
   <https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Felipe Carvalho, \email{lipecaso@gmail.com}

Felipe Carlos, \email{efelipecarlos@gmail.com}
}
