% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_smooth.R
\name{sits_smooth}
\alias{sits_smooth}
\alias{sits_smooth.probs_cube}
\alias{sits_smooth.probs_vector_cube}
\alias{sits_smooth.raster_cube}
\alias{sits_smooth.derived_cube}
\alias{sits_smooth.default}
\title{Smooth probability cubes with spatial predictors}
\usage{
sits_smooth(cube, ...)

\method{sits_smooth}{probs_cube}(
  cube,
  ...,
  window_size = 9L,
  neigh_fraction = 0.5,
  smoothness = 20L,
  exclusion_mask = NULL,
  memsize = 4L,
  multicores = 2L,
  output_dir,
  version = "v1"
)

\method{sits_smooth}{probs_vector_cube}(cube, ...)

\method{sits_smooth}{raster_cube}(cube, ...)

\method{sits_smooth}{derived_cube}(cube, ...)

\method{sits_smooth}{default}(cube, ...)
}
\arguments{
\item{cube}{Probability data cube.}

\item{...}{Other parameters for specific functions.}

\item{window_size}{Size of the neighborhood
(integer, min = 3, max = 21)}

\item{neigh_fraction}{Fraction of neighbors with high probabilities
to be used in Bayesian inference.
(numeric, min = 0.1, max = 1.0)}

\item{smoothness}{Estimated variance of logit of class probabilities
(Bayesian smoothing parameter)
(integer vector or scalar, min = 1, max = 200).}

\item{exclusion_mask}{Areas to be excluded from the classification
process. It can be defined as a sf object or a
shapefile.}

\item{memsize}{Memory available for classification in GB
(integer, min = 1, max = 16384).}

\item{multicores}{Number of cores to be used for classification
(integer, min = 1, max = 2048).}

\item{output_dir}{Valid directory for output file.
(character vector of length 1).}

\item{version}{Version of the output
(character vector of length 1).}
}
\value{
A data cube.
}
\description{
Takes a set of classified raster layers with probabilities,
             whose metadata is]created by \code{\link[sits]{sits_cube}},
             and applies a Bayesian smoothing function.
}
\examples{
if (sits_run_examples()) {
    # create am xgboost model
    xgb_model <- sits_train(samples_modis_ndvi, sits_xgboost())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = xgb_model, output_dir = tempdir()
    )
    # plot the probability cube
    plot(probs_cube)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube, output_dir = tempdir())
    # plot the smoothed cube
    plot(bayes_cube)
    # label the probability cube
    label_cube <- sits_label_classification(
        bayes_cube,
        output_dir = tempdir()
    )
    # plot the labelled cube
    plot(label_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
