% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_train.R
\name{sits_train}
\alias{sits_train}
\title{Train classification models}
\usage{
sits_train(samples, ml_method = sits_svm())
}
\arguments{
\item{samples}{Time series with the training samples.}

\item{ml_method}{Machine learning method.}
}
\value{
Model fitted to input data
                         to be passed to \code{\link[sits]{sits_classify}}
}
\description{
Given a tibble with a set of distance measures,
   returns trained models. Currently, sits supports the following models:
'svm' (see \code{\link[sits]{sits_svm}}),
random forests (see \code{\link[sits]{sits_rfor}}),
extreme gradient boosting (see \code{\link[sits]{sits_xgboost}}),
and different deep learning functions, including multi-layer perceptrons
(see \code{\link[sits]{sits_mlp}}), 1D convolution neural
networks \code{\link[sits]{sits_tempcnn}},
deep residual networks \code{\link[sits]{sits_resnet}} and
self-attention encoders \code{\link[sits]{sits_lighttae}}
}
\examples{
if (sits_run_examples()) {
    # Retrieve the set of samples for Mato Grosso
    # fit a training model (rfor model)
    ml_model <- sits_train(samples_modis_ndvi, sits_rfor(num_trees = 50))
    # get a point and classify the point with the ml_model
    point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")
    class <- sits_classify(
        data = point_ndvi, ml_model = ml_model
    )
}
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}

Gilberto Camara, \email{gilberto.camara@inpe.br}

Alexandre Ywata de Carvalho, \email{alexandre.ywata@ipea.gov.br}
}
