% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_uncertainty.R
\name{sits_uncertainty}
\alias{sits_uncertainty}
\alias{sits_uncertainty.least}
\alias{sits_uncertainty.entropy}
\alias{sits_uncertainty.margin}
\title{Estimate classification uncertainty based on probs cube}
\usage{
sits_uncertainty(
  cube,
  type = "least",
  window_size = 5,
  memsize = 4,
  multicores = 2,
  output_dir = getwd(),
  version = "v1"
)

\method{sits_uncertainty}{least}(
  cube,
  type = "least",
  window_size = 5,
  memsize = 4,
  multicores = 2,
  output_dir = getwd(),
  version = "v1"
)

\method{sits_uncertainty}{entropy}(
  cube,
  type = "entropy",
  window_size = 5,
  memsize = 4,
  multicores = 2,
  output_dir = getwd(),
  version = "v1"
)

\method{sits_uncertainty}{margin}(
  cube,
  type = "margin",
  window_size = 5,
  memsize = 4,
  multicores = 2,
  output_dir = getwd(),
  version = "v1"
)
}
\arguments{
\item{cube}{Probability data cube.}

\item{type}{Method to measure uncertainty. See details.}

\item{window_size}{Size of neighborhood to calculate uncertainty.}

\item{memsize}{Maximum overall memory (in GB) to run the function.}

\item{multicores}{Number of cores to run the function.}

\item{output_dir}{Output directory for image files.}

\item{version}{Version of resulting image (in the case of
multiple tests).}
}
\value{
An uncertainty data cube
}
\description{
Calculate the uncertainty cube based on the probabilities
produced by the classifier. Takes a probability cube as input.
The uncertainty measure is relevant in the context of active leaning,
and helps to increase the quantity and quality of training samples by
providing information about the confidence of the model.
The supported types of uncertainty are 'entropy', 'least', and 'margin'.
'entropy' is the difference between all predictions expressed as
entropy, 'least' is the difference between 100% and most confident
prediction, and 'margin' is the difference between the two most confident
predictions.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # calculate uncertainty
    uncert_cube <- sits_uncertainty(probs_cube)
    # plot the resulting uncertainty cube
    plot(uncert_cube)
}
}
\references{
Monarch, Robert Munro. Human-in-the-Loop Machine Learning:
Active learning and annotation for human-centered AI. Simon and Schuster,
2021.
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Alber Sanchez, \email{alber.ipia@inpe.br}
}
