% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_bbox.R
\name{sits_bbox}
\alias{sits_bbox}
\alias{sits_bbox.sits}
\alias{sits_bbox.raster_cube}
\title{Get the bounding box of the data}
\usage{
sits_bbox(data, ..., as_crs = NULL)

\method{sits_bbox}{sits}(data, ..., crs = "EPSG:4326", as_crs = NULL)

\method{sits_bbox}{raster_cube}(data, ..., as_crs = NULL)
}
\arguments{
\item{data}{\code{samples} data or \code{cube}.}

\item{...}{Additional parameters.}

\item{as_crs}{CRS to project the resulting \code{bbox}.}

\item{crs}{CRS of the samples points.}
}
\value{
A \code{bbox}.
}
\description{
Obtain a vector of limits (either on lat/long for time series
              or in projection coordinates in the case of cubes)
}
\examples{
if (sits_run_examples()) {
sits_bbox(samples_modis_ndvi)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
