% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_gdalcubes.R
\name{.gc_regularize}
\alias{.gc_regularize}
\title{Build a regular data cube from an irregular one}
\usage{
.gc_regularize(
  cube,
  period,
  res,
  roi,
  output_dir,
  multicores = 1,
  progress = TRUE
)
}
\arguments{
\item{cube}{Data cube whose spacing of observation
times is not constant and will be regularized
by the \code{gdalcubes} package.}

\item{period}{ISO8601 time period for regular data cubes
with number and unit, e.g., "P16D" for 16 days.
Use "D", "M" and "Y" for days, month and year.}

\item{res}{Spatial resolution of the regularized images.}

\item{roi}{A named \code{numeric} vector with a region of interest.}

\item{output_dir}{Valid directory where the
regularized images will be written.}

\item{multicores}{Number of cores used for regularization.}

\item{progress}{Show progress bar?}
}
\value{
Data cube with aggregated images.
}
\description{
Creates cubes with regular time intervals
 using the gdalcubes package.
}
\references{
Appel, Marius; Pebesma, Edzer. On-demand processing of data cubes
 from satellite image collections with the gdalcubes library. Data, v. 4,
 n. 3, p. 92, 2019. DOI: 10.3390/data4030092.
}
\keyword{internal}
