## ----eval = F, engine='bash'---------------------------------------------
## xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
##                  Starting BigCrush
##                  Version: TestU01 1.2.3
## xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
## 
## 
## ***********************************************************
## Test smarsa_SerialOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Sitmos-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N =  1,  n = 1000000000,  r =  0,   d =  256,   t =  3,
##        Sparse =  FALSE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =           16777216
##        Expected number per cell =   59.604645
##        Hashing =  FALSE
## 
##    For Delta > -1, we use the ChiSquare approximation
##    Correction factor of the ChiSquare:
##        Delta =     1,    Mu =   0.0083558402,    Sigma =          1
## 
## -----------------------------------------------
## Test Results for Delta =   1.0000
## 
## Number of degrees of freedom          : 16711680
## Value of the statistic                : 1.67e+7
## p-value of test                       :    0.59
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:04.53
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_SerialOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N =  1,  n = 1000000000,  r = 22,   d =  256,   t =  3,
##        Sparse =  FALSE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =           16777216
##        Expected number per cell =   59.604645
##        Hashing =  FALSE
## 
##    For Delta > -1, we use the ChiSquare approximation
##    Correction factor of the ChiSquare:
##        Delta =     1,    Mu =   0.0083558402,    Sigma =          1
## 
## -----------------------------------------------
## Test Results for Delta =   1.0000
## 
## Number of degrees of freedom          : 16711680
## Value of the statistic                : 1.67e+7
## p-value of test                       :    0.42
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:08.78
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r =  0,   d = 2097152,   t =  2,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1445
## p-value of test                       :    0.02
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334565
##   j =  1                              :        599997110
##   j =  2                              :             1445
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:03:49.93
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r =  9,   d = 2097152,   t =  2,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1294
## p-value of test                       :    0.97
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334414
##   j =  1                              :        599997412
##   j =  2                              :             1294
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:03:44.17
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r =  0,   d = 16384,   t =  3,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1341
## p-value of test                       :    0.73
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334461
##   j =  1                              :        599997318
##   j =  2                              :             1341
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:43.85
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r = 16,   d = 16384,   t =  3,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1401
## p-value of test                       :    0.16
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334521
##   j =  1                              :        599997198
##   j =  2                              :             1401
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:38.33
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r =  0,   d =   64,   t =  7,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1363
## p-value of test                       :    0.51
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334483
##   j =  1                              :        599997274
##   j =  2                              :             1363
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:45.35
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r = 24,   d =   64,   t =  7,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1312
## p-value of test                       :    0.92
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334432
##   j =  1                              :        599997376
##   j =  2                              :             1312
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:41.50
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r =  0,   d =    8,   t = 14,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1373
## p-value of test                       :    0.41
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334493
##   j =  1                              :        599997254
##   j =  2                              :             1373
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:45.18
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r = 27,   d =    8,   t = 14,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1360
## p-value of test                       :    0.54
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334480
##   j =  1                              :        599997280
##   j =  2                              :             1360
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:41.13
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r =  0,   d =    4,   t = 21,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1355
## p-value of test                       :    0.59
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334475
##   j =  1                              :        599997290
##   j =  2                              :             1355
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:43.98
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test smarsa_CollisionOver calling smultin_MultinomialOver
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_MultinomialOver test:
## -----------------------------------------------
##    N = 30,  n = 20000000,  r = 28,   d =    4,   t = 21,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellSerial
##        Number of cells = d^t =      4398046511104
##        Expected number per cell =  1 /  219902.33
##        EColl = n^2 / (2k) =  45.47473509
##        Hashing =   TRUE
## 
##        Collision test
## 
##        CollisionOver:   density = n / k =  1 /  219902.33
##        Expected number of collisions = Mu =      45.47
## 
## 
## -----------------------------------------------
## Results of CollisionOver test:
## 
## POISSON approximation                 :
## Expected number of collisions = N*Mu  :     1364.24
## Observed number of collisions         :     1387
## p-value of test                       :    0.27
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :  131940795334507
##   j =  1                              :        599997226
##   j =  2                              :             1387
##   j =  3                              :                0
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:39.21
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 100,  n = 10000000,  r =  0,    d = 2147483648,    t = 2,    p = 1
## 
## 
##       Number of cells = d^t = 4611686018427387904
##       Lambda = Poisson mean =      54.2101
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    5421.01
## Total observed number                 :    5379
## p-value of test                       :    0.71
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:03:58.55
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 20000000,  r =  0,    d = 2097152,    t = 3,    p = 1
## 
## 
##       Number of cells = d^t = 9223372036854775808
##       Lambda = Poisson mean =     216.8404
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    4336.81
## Total observed number                 :    4347
## p-value of test                       :    0.44
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:44.53
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 30000000,  r = 14,    d = 65536,    t = 4,    p = 1
## 
## 
##       Number of cells = d^t = 18446744073709551616
##       Lambda = Poisson mean =     365.9182
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    7318.36
## Total observed number                 :    7383
## p-value of test                       :    0.23
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:02:48.51
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 20000000,  r =  0,    d = 512,    t = 7,    p = 1
## 
## 
##       Number of cells = d^t = 9223372036854775808
##       Lambda = Poisson mean =     216.8404
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    4336.81
## Total observed number                 :    4299
## p-value of test                       :    0.71
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:59.94
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 20000000,  r =  7,    d = 512,    t = 7,    p = 1
## 
## 
##       Number of cells = d^t = 9223372036854775808
##       Lambda = Poisson mean =     216.8404
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    4336.81
## Total observed number                 :    4377
## p-value of test                       :    0.27
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:02:05.76
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 30000000,  r = 14,    d = 256,    t = 8,    p = 1
## 
## 
##       Number of cells = d^t = 18446744073709551616
##       Lambda = Poisson mean =     365.9182
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    7318.36
## Total observed number                 :    7325
## p-value of test                       :    0.47
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:03:19.07
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 30000000,  r = 22,    d = 256,    t = 8,    p = 1
## 
## 
##       Number of cells = d^t = 18446744073709551616
##       Lambda = Poisson mean =     365.9182
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    7318.36
## Total observed number                 :    7294
## p-value of test                       :    0.61
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:03:19.19
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 30000000,  r =  0,    d = 16,    t = 16,    p = 1
## 
## 
##       Number of cells = d^t = 18446744073709551616
##       Lambda = Poisson mean =     365.9182
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    7318.36
## Total observed number                 :    7366
## p-value of test                       :    0.29
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:04:00.28
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_BirthdaySpacings test:
## -----------------------------------------------
##    N = 20,  n = 30000000,  r = 26,    d = 16,    t = 16,    p = 1
## 
## 
##       Number of cells = d^t = 18446744073709551616
##       Lambda = Poisson mean =     365.9182
## 
## 
## ----------------------------------------------------
## Total expected number = N*Lambda      :    7318.36
## Total observed number                 :    7357
## p-value of test                       :    0.33
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:04:19.81
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## snpair_ClosePairs test:
## -----------------------------------------------
##    N = 30,  n = 6000000,  r =  0,  t = 3,  p = 0,  m = 30,  Torus =  TRUE
## 
## 
## ---------------------------------------
## Test based on the 2 nearest points (NP):
## 
## Stat. AD on the N values (NP)         :    0.30
## p-value of test                       :    0.93
## 
## 
## A2 test based on the spacings between the
##    successive jump times of process Y_n(t):
## 
## A2 test on the values of A2 (m-NP)    :    0.55
## p-value of test                       :    0.69
## 
## Test on the Nm values of W_{n,i}(mNP1):    1.63
## p-value of test                       :    0.15
## 
## Test on the jump times of Y
##    (superposition of Yn):
## 
## Expected number of jumps of Y = mN    :     900
## Number of jumps of Y                  :     970
## p-value of test                       :    0.01
## 
## Stat. AD (mNP2)                       :    1.27
## p-value of test                       :    0.24
## 
## Stat. AD after spacings (mNP2-S)      :    1.48
## p-value of test                       :    0.18
## 
## -----------------------------------------------
## CPU time used                    :  00:02:35.76
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## snpair_ClosePairs test:
## -----------------------------------------------
##    N = 20,  n = 4000000,  r =  0,  t = 5,  p = 0,  m = 30,  Torus =  TRUE
## 
## 
## ---------------------------------------
## Test based on the 2 nearest points (NP):
## 
## Stat. AD on the N values (NP)         :    1.33
## p-value of test                       :    0.22
## 
## 
## A2 test based on the spacings between the
##    successive jump times of process Y_n(t):
## 
## A2 test on the values of A2 (m-NP)    :    0.58
## p-value of test                       :    0.67
## 
## Test on the Nm values of W_{n,i}(mNP1):    0.76
## p-value of test                       :    0.51
## 
## Test on the jump times of Y
##    (superposition of Yn):
## 
## Expected number of jumps of Y = mN    :     600
## Number of jumps of Y                  :     577
## p-value of test                       :    0.82
## 
## Stat. AD (mNP2)                       :    1.31
## p-value of test                       :    0.23
## 
## Stat. AD after spacings (mNP2-S)      :    0.81
## p-value of test                       :    0.48
## 
## -----------------------------------------------
## CPU time used                    :  00:01:45.47
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## snpair_ClosePairs test:
## -----------------------------------------------
##    N = 10,  n = 3000000,  r =  0,  t = 9,  p = 0,  m = 30,  Torus =  TRUE
## 
## 
## ---------------------------------------
## Test based on the 2 nearest points (NP):
## 
## Stat. AD on the N values (NP)         :    0.52
## p-value of test                       :    0.73
## 
## 
## A2 test based on the spacings between the
##    successive jump times of process Y_n(t):
## 
## A2 test on the values of A2 (m-NP)    :    0.29
## p-value of test                       :    0.94
## 
## Test on the Nm values of W_{n,i}(mNP1):    1.48
## p-value of test                       :    0.18
## 
## Test on the jump times of Y
##    (superposition of Yn):
## 
## Expected number of jumps of Y = mN    :     300
## Number of jumps of Y                  :     260
## p-value of test                       :    0.99
## 
## Stat. AD (mNP2)                       :    0.71
## p-value of test                       :    0.55
## 
## Stat. AD after spacings (mNP2-S)      :    0.62
## p-value of test                       :    0.63
## 
## -----------------------------------------------
## CPU time used                    :  00:02:55.40
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## snpair_ClosePairs test:
## -----------------------------------------------
##    N =  5,  n = 2000000,  r =  0,  t = 16,  p = 0,  m = 30,  Torus =  TRUE
## 
## 
## ---------------------------------------
## Test based on the 2 nearest points (NP):
## 
## Stat. AD on the N values (NP)         :    1.24
## p-value of test                       :    0.25
## 
## 
## A2 test based on the spacings between the
##    successive jump times of process Y_n(t):
## 
## A2 test on the values of A2 (m-NP)    :    0.54
## p-value of test                       :    0.70
## 
## Test on the Nm values of W_{n,i}(mNP1):    1.31
## p-value of test                       :    0.23
## 
## Test on the jump times of Y
##    (superposition of Yn):
## 
## Expected number of jumps of Y = mN    :     150
## Number of jumps of Y                  :     150
## p-value of test                       :    0.51
## 
## Stat. AD (mNP2)                       :    3.70
## p-value of test                       :    0.01
## 
## Stat. AD after spacings (mNP2-S)      :    0.89
## p-value of test                       :    0.42
## 
## -----------------------------------------------
## CPU time used                    :  00:03:22.78
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_SimpPoker test:
## -----------------------------------------------
##    N =  1,  n = 400000000,  r =  0,   d =    8,   k =    8
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    7
## Chi-square statistic                  :    5.92
## p-value of test                       :    0.55
## 
## -----------------------------------------------
## CPU time used                    :  00:00:59.10
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_SimpPoker test:
## -----------------------------------------------
##    N =  1,  n = 400000000,  r = 27,   d =    8,   k =    8
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    7
## Chi-square statistic                  :    3.46
## p-value of test                       :    0.84
## 
## -----------------------------------------------
## CPU time used                    :  00:01:09.35
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_SimpPoker test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r =  0,   d =   32,   k =   32
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   18
## Chi-square statistic                  :    9.52
## p-value of test                       :    0.95
## 
## -----------------------------------------------
## CPU time used                    :  00:01:02.60
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_SimpPoker test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r = 25,   d =   32,   k =   32
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   18
## Chi-square statistic                  :   14.29
## p-value of test                       :    0.71
## 
## -----------------------------------------------
## CPU time used                    :  00:01:13.81
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_CouponCollector test:
## -----------------------------------------------
##    N =  1,  n = 200000000,  r =  0,   d =    8
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   54
## Chi-square statistic                  :   44.18
## p-value of test                       :    0.83
## 
## -----------------------------------------------
## CPU time used                    :  00:01:16.02
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_CouponCollector test:
## -----------------------------------------------
##    N =  1,  n = 200000000,  r = 10,   d =    8
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   54
## Chi-square statistic                  :   47.86
## p-value of test                       :    0.71
## 
## -----------------------------------------------
## CPU time used                    :  00:01:28.55
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_CouponCollector test:
## -----------------------------------------------
##    N =  1,  n = 200000000,  r = 20,   d =    8
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   54
## Chi-square statistic                  :   50.86
## p-value of test                       :    0.60
## 
## -----------------------------------------------
## CPU time used                    :  00:01:28.60
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_CouponCollector test:
## -----------------------------------------------
##    N =  1,  n = 200000000,  r = 27,   d =    8
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   54
## Chi-square statistic                  :   58.93
## p-value of test                       :    0.30
## 
## -----------------------------------------------
## CPU time used                    :  00:01:28.68
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_Gap test:
## -----------------------------------------------
##    N =  1,  n = 500000000,  r =  0,   Alpha =        0,   Beta  =   0.0625
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :  232
## Chi-square statistic                  :  214.26
## p-value of test                       :    0.79
## 
## -----------------------------------------------
## CPU time used                    :  00:01:32.96
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_Gap test:
## -----------------------------------------------
##    N =  1,  n = 300000000,  r = 25,   Alpha =        0,   Beta  =  0.03125
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :  434
## Chi-square statistic                  :  397.76
## p-value of test                       :    0.89
## 
## -----------------------------------------------
## CPU time used                    :  00:02:06.14
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_Gap test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r =  0,   Alpha =        0,   Beta  = 0.0078125
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          : 1437
## Chi-square statistic                  : 1481.41
## p-value of test                       :    0.20
## 
## -----------------------------------------------
## CPU time used                    :  00:02:13.51
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_Gap test:
## -----------------------------------------------
##    N =  1,  n = 10000000,  r = 20,   Alpha =        0,   Beta  = 0.000976562
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          : 7046
## Chi-square statistic                  : 7166.64
## p-value of test                       :    0.15
## 
## -----------------------------------------------
## CPU time used                    :  00:02:08.09
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_Run test:
## -----------------------------------------------
##    N =  5,  n = 1000000000,  r =  0,   Up = FALSE
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.50
## p-value of test                       :    0.05
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.14
## p-value of test                       :    0.77
## 
## Anderson-Darling statistic = A2       :    2.25
## p-value of test                       :    0.07
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :   30
## Chi-square statistic                  :   22.54
## p-value of test                       :    0.83
## 
## -----------------------------------------------
## CPU time used                    :  00:01:23.93
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_Run test:
## -----------------------------------------------
##    N = 10,  n = 1000000000,  r = 15,   Up =  TRUE
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.21
## p-value of test                       :    0.35
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.15
## p-value of test                       :    0.59
## 
## Anderson-Darling statistic = A2       :    0.50
## p-value of test                       :    0.75
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :   60
## Chi-square statistic                  :   58.53
## p-value of test                       :    0.53
## 
## -----------------------------------------------
## CPU time used                    :  00:03:11.42
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test sknuth_Permutation calling smultin_Multinomial
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_Multinomial test:
## -----------------------------------------------
##    N =  1,  n = 1000000000,  r =  5,   t =  3,
##        Sparse =  FALSE
## 
##        GenerCell = smultin_GenerCellPermut
##        Number of cells = t! =                  6
##        Expected number per cell =  1.6666667e+08
##        Hashing =  FALSE
## 
##    For Delta > -1, we use the ChiSquare approximation
##    Correction factor of the ChiSquare:
##        Delta =     1,    Mu =  2.5000002e-09,    Sigma =          1
## 
## -----------------------------------------------
## Test Results for Delta =   1.0000
## 
## Number of degrees of freedom          :    5
## Value of the statistic                :    8.17
## p-value of test                       :    0.15
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:00:46.93
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test sknuth_Permutation calling smultin_Multinomial
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_Multinomial test:
## -----------------------------------------------
##    N =  1,  n = 1000000000,  r =  5,   t =  5,
##        Sparse =  FALSE
## 
##        GenerCell = smultin_GenerCellPermut
##        Number of cells = t! =                120
##        Expected number per cell =   8333333.3
##        Hashing =  FALSE
## 
##    For Delta > -1, we use the ChiSquare approximation
##    Correction factor of the ChiSquare:
##        Delta =     1,    Mu =  5.9500005e-08,    Sigma =          1
## 
## -----------------------------------------------
## Test Results for Delta =   1.0000
## 
## Number of degrees of freedom          :  119
## Value of the statistic                :  108.58
## p-value of test                       :    0.74
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:35.02
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test sknuth_Permutation calling smultin_Multinomial
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_Multinomial test:
## -----------------------------------------------
##    N =  1,  n = 500000000,  r =  5,   t =  7,
##        Sparse =  FALSE
## 
##        GenerCell = smultin_GenerCellPermut
##        Number of cells = t! =               5040
##        Expected number per cell =   99206.349
##        Hashing =  FALSE
## 
##    For Delta > -1, we use the ChiSquare approximation
##    Correction factor of the ChiSquare:
##        Delta =     1,    Mu =  5.0390004e-06,    Sigma =          1
## 
## -----------------------------------------------
## Test Results for Delta =   1.0000
## 
## Number of degrees of freedom          : 5039
## Value of the statistic                : 4810.30
## p-value of test                       :    0.99
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:24.63
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test sknuth_Permutation calling smultin_Multinomial
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_Multinomial test:
## -----------------------------------------------
##    N =  1,  n = 500000000,  r = 10,   t = 10,
##        Sparse =  FALSE
## 
##        GenerCell = smultin_GenerCellPermut
##        Number of cells = t! =            3628800
##        Expected number per cell =    137.7866
##        Hashing =  FALSE
## 
##    For Delta > -1, we use the ChiSquare approximation
##    Correction factor of the ChiSquare:
##        Delta =     1,    Mu =   0.0036287993,    Sigma =          1
## 
## -----------------------------------------------
## Test Results for Delta =   1.0000
## 
## Number of degrees of freedom          : 3628799
## Value of the statistic                : 3.63e+6
## p-value of test                       :    0.80
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:03:06.50
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test sknuth_CollisionPermut calling smultin_Multinomial
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_Multinomial test:
## -----------------------------------------------
##    N = 20,  n = 20000000,  r =  0,   t = 14,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellPermut
##        Number of cells = t! =        87178291200
##        Expected number per cell =  1 /  4358.9146
##        EColl = n^2 / (2k) =   2294.14912
##        Hashing =   TRUE
## 
##        Collision test,    Mu =      2293.9736,    Sigma =    47.8841
## 
## -----------------------------------------------
## Test Results for Collisions
## 
## For the total number of collisions, we use
##       the Poisson approximation:
## Expected number of collisions = N*Mu  :    45879.47
## Observed number of collisions         :    45892
## p-value of test                       :    0.48
## 
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :    1743165869892
##   j =  1                              :        399908218
##   j =  2                              :            45888
##   j =  3                              :                2
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:04:54.47
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## Test sknuth_CollisionPermut calling smultin_Multinomial
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smultin_Multinomial test:
## -----------------------------------------------
##    N = 20,  n = 20000000,  r = 10,   t = 14,
##        Sparse =   TRUE
## 
##        GenerCell = smultin_GenerCellPermut
##        Number of cells = t! =        87178291200
##        Expected number per cell =  1 /  4358.9146
##        EColl = n^2 / (2k) =   2294.14912
##        Hashing =   TRUE
## 
##        Collision test,    Mu =      2293.9736,    Sigma =    47.8841
## 
## -----------------------------------------------
## Test Results for Collisions
## 
## For the total number of collisions, we use
##       the Poisson approximation:
## Expected number of collisions = N*Mu  :    45879.47
## Observed number of collisions         :    45960
## p-value of test                       :    0.35
## 
## 
## -----------------------------
## Total number of cells containing j balls
## 
##   j =  0                              :    1743165869960
##   j =  1                              :        399908084
##   j =  2                              :            45952
##   j =  3                              :                4
##   j =  4                              :                0
##   j =  5                              :                0
## 
## -----------------------------------------------
## CPU time used                    :  00:05:01.14
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_MaxOft test:
## -----------------------------------------------
##    N = 40,  n = 10000000,  r =  0,   d = 100000,   t =  8
## 
##       Number of categories = 100000
##       Expected number per category  = 100.00
## 
## 
## -----------------------------------------------
## Test results for chi2 with 99999 degrees of freedom:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.11
## p-value of test                       :    0.35
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.036
## p-value of test                       :    0.88
## 
## Anderson-Darling statistic = A2       :    0.61
## p-value of test                       :    0.64
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 3999960
## Chi-square statistic                  : 4.00e+6
## p-value of test                       :    0.77
## 
## 
## -----------------------------------------------
## Test results for Anderson-Darling:
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.091
## p-value of test                       :    0.49
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.054
## p-value of test                       :    0.77
## 
## Anderson-Darling statistic = A2       :    0.41
## p-value of test                       :    0.84
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:45.23
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_MaxOft test:
## -----------------------------------------------
##    N = 30,  n = 10000000,  r =  0,   d = 100000,   t = 16
## 
##       Number of categories = 100000
##       Expected number per category  = 100.00
## 
## 
## -----------------------------------------------
## Test results for chi2 with 99999 degrees of freedom:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.13
## p-value of test                       :    0.32
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.17
## p-value of test                       :    0.17
## 
## Anderson-Darling statistic = A2       :    1.26
## p-value of test                       :    0.25
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 2999970
## Chi-square statistic                  : 3.00e+6
## p-value of test                       :    0.40
## 
## 
## -----------------------------------------------
## Test results for Anderson-Darling:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.19
## p-value of test                       :    0.11
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.014
## p-value of test                       :    0.98
## 
## Anderson-Darling statistic = A2       :    1.61
## p-value of test                       :    0.15
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:43.48
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_MaxOft test:
## -----------------------------------------------
##    N = 20,  n = 10000000,  r =  0,   d = 100000,   t = 24
## 
##       Number of categories = 100000
##       Expected number per category  = 100.00
## 
## 
## -----------------------------------------------
## Test results for chi2 with 99999 degrees of freedom:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.15
## p-value of test                       :    0.38
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.12
## p-value of test                       :    0.54
## 
## Anderson-Darling statistic = A2       :    0.55
## p-value of test                       :    0.69
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 1999980
## Chi-square statistic                  : 2.00e+6
## p-value of test                       :    0.64
## 
## 
## -----------------------------------------------
## Test results for Anderson-Darling:
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.040
## p-value of test                       :    0.91
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.19
## p-value of test                       :    0.23
## 
## Anderson-Darling statistic = A2       :    0.94
## p-value of test                       :    0.39
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:27.73
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sknuth_MaxOft test:
## -----------------------------------------------
##    N = 20,  n = 10000000,  r =  0,   d = 100000,   t = 32
## 
##       Number of categories = 100000
##       Expected number per category  = 100.00
## 
## 
## -----------------------------------------------
## Test results for chi2 with 99999 degrees of freedom:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.12
## p-value of test                       :    0.51
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.100
## p-value of test                       :    0.63
## 
## Anderson-Darling statistic = A2       :    0.49
## p-value of test                       :    0.75
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 1999980
## Chi-square statistic                  : 2.00e+6
## p-value of test                       :    0.64
## 
## 
## -----------------------------------------------
## Test results for Anderson-Darling:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.10
## p-value of test                       :    0.61
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.16
## p-value of test                       :    0.33
## 
## Anderson-Darling statistic = A2       :    0.79
## p-value of test                       :    0.48
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:43.31
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleProd test:
## -----------------------------------------------
##    N = 40,  n = 10000000,  r =  0,   t = 8
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.18
## p-value of test                       :    0.06
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.049
## p-value of test                       :    0.80
## 
## Anderson-Darling statistic = A2       :    1.90
## p-value of test                       :    0.10
## 
## -----------------------------------------------
## CPU time used                    :  00:01:54.64
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleProd test:
## -----------------------------------------------
##    N = 20,  n = 10000000,  r =  0,   t = 16
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.24
## p-value of test                       :    0.08
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.043
## p-value of test                       :    0.90
## 
## Anderson-Darling statistic = A2       :    2.22
## p-value of test                       :    0.07
## 
## -----------------------------------------------
## CPU time used                    :  00:01:29.65
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleProd test:
## -----------------------------------------------
##    N = 20,  n = 10000000,  r =  0,   t = 24
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.23
## p-value of test                       :    0.10
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.012
## p-value of test                       :    0.98
## 
## Anderson-Darling statistic = A2       :    1.69
## p-value of test                       :    0.14
## 
## -----------------------------------------------
## CPU time used                    :  00:02:04.43
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleMean test:
## -----------------------------------------------
##    N = 20000000,  n = 30,  r =  0
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    : 1.93e-4
## p-value of test                       :    0.22
## 
## Kolmogorov-Smirnov- statistic = D-    : 7.01e-5
## p-value of test                       :    0.82
## 
## Anderson-Darling statistic = A2       :    0.50
## p-value of test                       :    0.74
## 
## -----------------------------------------------
## CPU time used                    :  00:00:15.09
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleMean test:
## -----------------------------------------------
##    N = 20000000,  n = 30,  r = 10
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    : 1.37e-4
## p-value of test                       :    0.47
## 
## Kolmogorov-Smirnov- statistic = D-    : 1.31e-4
## p-value of test                       :    0.50
## 
## Anderson-Darling statistic = A2       :    0.49
## p-value of test                       :    0.76
## 
## -----------------------------------------------
## CPU time used                    :  00:00:15.52
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleCorr test:
## -----------------------------------------------
##    N =  1,  n = 2000000000,  r =  0,   k = 1
## 
## 
## -----------------------------------------------
## Normal statistic                      :   -1.75
## p-value of test                       :    0.96
## 
## -----------------------------------------------
## CPU time used                    :  00:00:23.87
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SampleCorr test:
## -----------------------------------------------
##    N =  1,  n = 2000000000,  r =  0,   k = 2
## 
## 
## -----------------------------------------------
## Normal statistic                      :    1.09
## p-value of test                       :    0.14
## 
## -----------------------------------------------
## CPU time used                    :  00:00:23.96
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_AppearanceSpacings test:
## -----------------------------------------------
##    N =  1,   Q = 10000000,   K = 1000000000,   r = 0,   s = 3,   L = 15
## 
##    Sequences of n = (K + Q)L =  15150000000 bits
##    Q = 10000000 initialization blocks
##    K = 1000000000 blocks for the test
##    the blocks have L = 15 bits
## 
## 
## 
## -----------------------------------------------
## Normal statistic                      :   -0.31
## p-value of test                       :    0.62
## 
## -----------------------------------------------
## CPU time used                    :  00:01:09.11
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_AppearanceSpacings test:
## -----------------------------------------------
##    N =  1,   Q = 10000000,   K = 1000000000,   r = 27,   s = 3,   L = 15
## 
##    Sequences of n = (K + Q)L =  15150000000 bits
##    Q = 10000000 initialization blocks
##    K = 1000000000 blocks for the test
##    the blocks have L = 15 bits
## 
## 
## 
## -----------------------------------------------
## Normal statistic                      :   -0.77
## p-value of test                       :    0.78
## 
## -----------------------------------------------
## CPU time used                    :  00:01:12.02
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_WeightDistrib test:
## -----------------------------------------------
##    N =  1,  n = 20000000,  r =  0,  k = 256,  Alpha =      0,  Beta =   0.25
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   67
## Chi-square statistic                  :   53.51
## p-value of test                       :    0.88
## 
## -----------------------------------------------
## CPU time used                    :  00:00:53.06
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_WeightDistrib test:
## -----------------------------------------------
##    N =  1,  n = 20000000,  r = 20,  k = 256,  Alpha =      0,  Beta =   0.25
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   67
## Chi-square statistic                  :   76.46
## p-value of test                       :    0.20
## 
## -----------------------------------------------
## CPU time used                    :  00:01:05.73
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_WeightDistrib test:
## -----------------------------------------------
##    N =  1,  n = 20000000,  r = 28,  k = 256,  Alpha =      0,  Beta =   0.25
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   67
## Chi-square statistic                  :   66.46
## p-value of test                       :    0.50
## 
## -----------------------------------------------
## CPU time used                    :  00:01:05.79
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_WeightDistrib test:
## -----------------------------------------------
##    N =  1,  n = 20000000,  r =  0,  k = 256,  Alpha =      0,  Beta = 0.0625
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   37
## Chi-square statistic                  :   32.57
## p-value of test                       :    0.68
## 
## -----------------------------------------------
## CPU time used                    :  00:00:53.05
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_WeightDistrib test:
## -----------------------------------------------
##    N =  1,  n = 20000000,  r = 10,  k = 256,  Alpha =      0,  Beta = 0.0625
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   37
## Chi-square statistic                  :   53.95
## p-value of test                       :    0.04
## 
## -----------------------------------------------
## CPU time used                    :  00:01:05.79
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_WeightDistrib test:
## -----------------------------------------------
##    N =  1,  n = 20000000,  r = 26,  k = 256,  Alpha =      0,  Beta = 0.0625
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   37
## Chi-square statistic                  :   18.95
## p-value of test                       :    0.9939
## 
## -----------------------------------------------
## CPU time used                    :  00:01:05.73
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## svaria_SumCollector test:
## -----------------------------------------------
##    N =  1,  n = 500000000,  r =  0,   g = 10
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   29
## Chi-square statistic                  :   22.00
## p-value of test                       :    0.82
## 
## -----------------------------------------------
## CPU time used                    :  00:01:58.36
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_MatrixRank test:
## -----------------------------------------------
##    N = 10,  n = 1000000,  r =  0,    s = 5,    L = 30,    k = 30
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.27
## p-value of test                       :    0.19
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.16
## p-value of test                       :    0.56
## 
## Anderson-Darling statistic = A2       :    0.78
## p-value of test                       :    0.50
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :   40
## Chi-square statistic                  :   32.66
## p-value of test                       :    0.79
## 
## -----------------------------------------------
## CPU time used                    :  00:01:16.26
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_MatrixRank test:
## -----------------------------------------------
##    N = 10,  n = 1000000,  r = 25,    s = 5,    L = 30,    k = 30
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.19
## p-value of test                       :    0.42
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.14
## p-value of test                       :    0.62
## 
## Anderson-Darling statistic = A2       :    0.49
## p-value of test                       :    0.75
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :   40
## Chi-square statistic                  :   34.46
## p-value of test                       :    0.72
## 
## -----------------------------------------------
## CPU time used                    :  00:01:16.23
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_MatrixRank test:
## -----------------------------------------------
##    N =  1,  n = 5000,  r =  0,    s = 4,    L = 1000,    k = 1000
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    3
## Chi-square statistic                  :    0.73
## p-value of test                       :    0.87
## 
## -----------------------------------------------
## CPU time used                    :  00:03:44.79
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_MatrixRank test:
## -----------------------------------------------
##    N =  1,  n = 5000,  r = 26,    s = 4,    L = 1000,    k = 1000
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    3
## Chi-square statistic                  :    1.12
## p-value of test                       :    0.77
## 
## -----------------------------------------------
## CPU time used                    :  00:03:44.77
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_MatrixRank test:
## -----------------------------------------------
##    N =  1,  n = 80,  r = 15,    s = 15,    L = 5000,    k = 5000
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    2
## Chi-square statistic                  :    6.04
## p-value of test                       :    0.05
## 
## -----------------------------------------------
## CPU time used                    :  00:03:28.23
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_MatrixRank test:
## -----------------------------------------------
##    N =  1,  n = 80,  r =  0,    s = 30,    L = 5000,    k = 5000
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    2
## Chi-square statistic                  :   0.075
## p-value of test                       :    0.96
## 
## -----------------------------------------------
## CPU time used                    :  00:02:51.20
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_Savir2 test:
## -----------------------------------------------
##    N = 10,  n = 10000000,  r = 10,    m = 1048576,    t = 30
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.027
## p-value of test                       :    0.97
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.41
## p-value of test                       :    0.02
## 
## Anderson-Darling statistic = A2       :    2.58
## p-value of test                       :    0.05
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :  130
## Chi-square statistic                  :  164.06
## p-value of test                       :    0.02
## 
## -----------------------------------------------
## CPU time used                    :  00:00:37.67
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## smarsa_GCD test:
## -----------------------------------------------
##    N = 10,  n = 50000000,  r =  0,   s = 30
## 
## 
## -----------------------------------------------
## Test results for GCD values:
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.34
## p-value of test                       :    0.08
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.026
## p-value of test                       :    0.97
## 
## Anderson-Darling statistic = A2       :    1.62
## p-value of test                       :    0.15
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 17430
## Chi-square statistic                  :17122.72
## p-value of test                       :    0.95
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:54.05
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## swalk_RandomWalk1 test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r =  0,   s = 5,   L0 =   50,   L1 =   50
## 
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic H
## 
## Number of degrees of freedom          :   36
## ChiSquare statistic                   :   30.27
## p-value of test                       :    0.74
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic M
## 
## Number of degrees of freedom          :   35
## ChiSquare statistic                   :   34.79
## p-value of test                       :    0.48
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic J
## 
## Number of degrees of freedom          :   25
## ChiSquare statistic                   :   34.88
## p-value of test                       :    0.09
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic R
## 
## Number of degrees of freedom          :   24
## ChiSquare statistic                   :   25.02
## p-value of test                       :    0.40
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic C
## 
## Number of degrees of freedom          :   17
## ChiSquare statistic                   :   24.18
## p-value of test                       :    0.11
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:00:47.70
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## swalk_RandomWalk1 test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r = 25,   s = 5,   L0 =   50,   L1 =   50
## 
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic H
## 
## Number of degrees of freedom          :   36
## ChiSquare statistic                   :   26.87
## p-value of test                       :    0.86
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic M
## 
## Number of degrees of freedom          :   35
## ChiSquare statistic                   :   25.33
## p-value of test                       :    0.89
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic J
## 
## Number of degrees of freedom          :   25
## ChiSquare statistic                   :   40.08
## p-value of test                       :    0.03
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic R
## 
## Number of degrees of freedom          :   24
## ChiSquare statistic                   :   19.29
## p-value of test                       :    0.74
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic C
## 
## Number of degrees of freedom          :   17
## ChiSquare statistic                   :   11.45
## p-value of test                       :    0.83
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:00:48.73
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## swalk_RandomWalk1 test:
## -----------------------------------------------
##    N =  1,  n = 10000000,  r =  0,   s = 10,   L0 = 1000,   L1 = 1000
## 
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic H
## 
## Number of degrees of freedom          :  146
## ChiSquare statistic                   :  177.55
## p-value of test                       :    0.04
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic M
## 
## Number of degrees of freedom          :  146
## ChiSquare statistic                   :  117.36
## p-value of test                       :    0.96
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic J
## 
## Number of degrees of freedom          :  500
## ChiSquare statistic                   :  438.13
## p-value of test                       :    0.98
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic R
## 
## Number of degrees of freedom          :  136
## ChiSquare statistic                   :  119.76
## p-value of test                       :    0.84
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic C
## 
## Number of degrees of freedom          :   74
## ChiSquare statistic                   :   86.45
## p-value of test                       :    0.15
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:06.36
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## swalk_RandomWalk1 test:
## -----------------------------------------------
##    N =  1,  n = 10000000,  r = 20,   s = 10,   L0 = 1000,   L1 = 1000
## 
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic H
## 
## Number of degrees of freedom          :  146
## ChiSquare statistic                   :  128.52
## p-value of test                       :    0.85
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic M
## 
## Number of degrees of freedom          :  146
## ChiSquare statistic                   :  139.85
## p-value of test                       :    0.63
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic J
## 
## Number of degrees of freedom          :  500
## ChiSquare statistic                   :  509.00
## p-value of test                       :    0.38
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic R
## 
## Number of degrees of freedom          :  136
## ChiSquare statistic                   :  125.25
## p-value of test                       :    0.74
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic C
## 
## Number of degrees of freedom          :   74
## ChiSquare statistic                   :   68.45
## p-value of test                       :    0.66
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:08.10
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## swalk_RandomWalk1 test:
## -----------------------------------------------
##    N =  1,  n = 1000000,  r =  0,   s = 15,   L0 = 10000,   L1 = 10000
## 
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic H
## 
## Number of degrees of freedom          :  384
## ChiSquare statistic                   :  396.65
## p-value of test                       :    0.32
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic M
## 
## Number of degrees of freedom          :  384
## ChiSquare statistic                   :  387.98
## p-value of test                       :    0.43
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic J
## 
## Number of degrees of freedom          : 5000
## ChiSquare statistic                   : 4987.07
## p-value of test                       :    0.55
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic R
## 
## Number of degrees of freedom          :  378
## ChiSquare statistic                   :  370.70
## p-value of test                       :    0.60
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic C
## 
## Number of degrees of freedom          :  200
## ChiSquare statistic                   :  202.48
## p-value of test                       :    0.44
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:00:57.94
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## swalk_RandomWalk1 test:
## -----------------------------------------------
##    N =  1,  n = 1000000,  r = 15,   s = 15,   L0 = 10000,   L1 = 10000
## 
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic H
## 
## Number of degrees of freedom          :  384
## ChiSquare statistic                   :  370.10
## p-value of test                       :    0.69
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic M
## 
## Number of degrees of freedom          :  384
## ChiSquare statistic                   :  369.10
## p-value of test                       :    0.70
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic J
## 
## Number of degrees of freedom          : 5000
## ChiSquare statistic                   : 4890.41
## p-value of test                       :    0.86
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic R
## 
## Number of degrees of freedom          :  378
## ChiSquare statistic                   :  357.68
## p-value of test                       :    0.77
## 
## 
## -----------------------------------------------
## Test on the values of the Statistic C
## 
## Number of degrees of freedom          :  200
## ChiSquare statistic                   :  180.54
## p-value of test                       :    0.83
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:00:58.79
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## scomp_LinearComp test:
## -----------------------------------------------
##    N =  1,  n = 400020,  r =  0,    s = 1
## 
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   12
## Chi2 statistic for size of jumps      :   12.60
## p-value of test                       :    0.40
## 
## 
## -----------------------------------------------
## Normal statistic for number of jumps  :    2.51
## p-value of test                       :  6.1e-3
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:02:43.68
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## scomp_LinearComp test:
## -----------------------------------------------
##    N =  1,  n = 400020,  r = 29,    s = 1
## 
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :   12
## Chi2 statistic for size of jumps      :    8.18
## p-value of test                       :    0.77
## 
## 
## -----------------------------------------------
## Normal statistic for number of jumps  :   -1.55
## p-value of test                       :    0.94
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:02:43.05
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## scomp_LempelZiv test:
## -----------------------------------------------
##    N = 10,  n = 134217728,  r =  0,   s =   30,   k =   27
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.23
## p-value of test                       :    0.31
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.13
## p-value of test                       :    0.65
## 
## Anderson-Darling statistic = A2       :    0.54
## p-value of test                       :    0.70
## 
## Tests on the sum of all N observations
## Standardized normal statistic         :   -0.32
## p-value of test                       :    0.63
## 
## Sample variance                       :    1.17
## p-value of test                       :    0.31
## 
## -----------------------------------------------
## CPU time used                    :  00:00:54.70
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## scomp_LempelZiv test:
## -----------------------------------------------
##    N = 10,  n = 134217728,  r = 15,   s =   15,   k =   27
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.20
## p-value of test                       :    0.40
## 
## Kolmogorov-Smirnov- statistic = D-    :   0.015
## p-value of test                       :    0.98
## 
## Anderson-Darling statistic = A2       :    0.73
## p-value of test                       :    0.53
## 
## Tests on the sum of all N observations
## Standardized normal statistic         :   -1.20
## p-value of test                       :    0.88
## 
## Sample variance                       :    0.89
## p-value of test                       :    0.53
## 
## -----------------------------------------------
## CPU time used                    :  00:00:55.27
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sspectral_Fourier3 test:
## -----------------------------------------------
##    N = 100000,  n = 16384,  r =  0,   s =    3,   k =   14
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.021
## p-value of test                       :    0.02
## 
## Kolmogorov-Smirnov- statistic = D-    : 9.76e-3
## p-value of test                       :    0.46
## 
## Anderson-Darling statistic = A2       :    2.29
## p-value of test                       :    0.06
## 
## -----------------------------------------------
## CPU time used                    :  00:00:39.04
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sspectral_Fourier3 test:
## -----------------------------------------------
##    N = 100000,  n = 16384,  r = 27,   s =    3,   k =   14
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.016
## p-value of test                       :    0.11
## 
## Kolmogorov-Smirnov- statistic = D-    : 4.76e-3
## p-value of test                       :    0.83
## 
## Anderson-Darling statistic = A2       :    1.57
## p-value of test                       :    0.16
## 
## -----------------------------------------------
## CPU time used                    :  00:00:39.54
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_LongestHeadRun test:
## -----------------------------------------------
##    N =  1,  n = 1000,  r =  0,   s = 3,   L = 10000020
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    8
## Chi-square statistic                  :    9.12
## p-value of test                       :    0.33
## 
## -----------------------------------------------
## Global longest run of 1               :   35.00
## p-value of test                       :    0.14
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:47.05
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_LongestHeadRun test:
## -----------------------------------------------
##    N =  1,  n = 1000,  r = 27,   s = 3,   L = 10000020
## 
## 
## -----------------------------------------------
## Number of degrees of freedom          :    8
## Chi-square statistic                  :    4.78
## p-value of test                       :    0.78
## 
## -----------------------------------------------
## Global longest run of 1               :   35.00
## p-value of test                       :    0.14
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:50.10
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_PeriodsInStrings test:
## -----------------------------------------------
##    N = 10,  n = 500000000,  r =  0,   s =   10
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.30
## p-value of test                       :    0.13
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.13
## p-value of test                       :    0.68
## 
## Anderson-Darling statistic = A2       :    0.84
## p-value of test                       :    0.45
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :  200
## Chi-square statistic                  :  183.59
## p-value of test                       :    0.79
## 
## -----------------------------------------------
## CPU time used                    :  00:02:51.45
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_PeriodsInStrings test:
## -----------------------------------------------
##    N = 10,  n = 500000000,  r = 20,   s =   10
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.25
## p-value of test                       :    0.25
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.17
## p-value of test                       :    0.51
## 
## Anderson-Darling statistic = A2       :    0.50
## p-value of test                       :    0.74
## 
## Test on the sum of all N observations
## Number of degrees of freedom          :  200
## Chi-square statistic                  :  195.89
## p-value of test                       :    0.57
## 
## -----------------------------------------------
## CPU time used                    :  00:02:56.45
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingWeight2 test:
## -----------------------------------------------
##    N = 10,  n = 1000000000,  r =  0,   s = 3,   L = 1000000
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.15
## p-value of test                       :    0.57
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.19
## p-value of test                       :    0.43
## 
## Anderson-Darling statistic = A2       :    1.02
## p-value of test                       :    0.34
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 10000
## Chi-square statistic                  :10157.86
## p-value of test                       :    0.13
## 
## -----------------------------------------------
## CPU time used                    :  00:00:57.75
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingWeight2 test:
## -----------------------------------------------
##    N = 10,  n = 1000000000,  r = 27,   s = 3,   L = 1000000
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.18
## p-value of test                       :    0.48
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.38
## p-value of test                       :    0.04
## 
## Anderson-Darling statistic = A2       :    1.47
## p-value of test                       :    0.18
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 10000
## Chi-square statistic                  :10121.19
## p-value of test                       :    0.20
## 
## -----------------------------------------------
## CPU time used                    :  00:01:01.20
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingCorr test:
## -----------------------------------------------
##    N =  1,  n = 1000000000,  r = 10,   s = 10,   L = 30
## 
## 
## 
## -----------------------------------------------
## Normal statistic                      :    1.36
## p-value of test                       :    0.09
## 
## -----------------------------------------------
## CPU time used                    :  00:01:13.01
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingCorr test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r = 10,   s = 10,   L = 300
## 
## 
## 
## -----------------------------------------------
## Normal statistic                      :    0.36
## p-value of test                       :    0.36
## 
## -----------------------------------------------
## CPU time used                    :  00:01:09.29
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingCorr test:
## -----------------------------------------------
##    N =  1,  n = 100000000,  r = 10,   s = 10,   L = 1200
## 
## 
## 
## -----------------------------------------------
## Normal statistic                      :   -0.12
## p-value of test                       :    0.55
## 
## -----------------------------------------------
## CPU time used                    :  00:04:34.86
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingIndep test:
## -----------------------------------------------
##    N = 10,  n = 30000000,  r =  0,   s = 3,   L = 30,   d = 0
## 
## 
## 
## Counters with expected numbers >= 10
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.24
## p-value of test                       :    0.28
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.13
## p-value of test                       :    0.65
## 
## Anderson-Darling statistic = A2       :    0.74
## p-value of test                       :    0.53
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 4890
## Chi-square statistic                  : 4850.28
## p-value of test                       :    0.65
## 
## -----------------------------------------------
## CPU time used                    :  00:01:53.80
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingIndep test:
## -----------------------------------------------
##    N = 10,  n = 30000000,  r = 27,   s = 3,   L = 30,   d = 0
## 
## 
## 
## Counters with expected numbers >= 10
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.25
## p-value of test                       :    0.24
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.11
## p-value of test                       :    0.74
## 
## Anderson-Darling statistic = A2       :    0.66
## p-value of test                       :    0.59
## 
## Test on the sum of all N observations
## Number of degrees of freedom          : 4890
## Chi-square statistic                  : 4816.01
## p-value of test                       :    0.77
## 
## -----------------------------------------------
## CPU time used                    :  00:01:59.57
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingIndep test:
## -----------------------------------------------
##    N =  1,  n = 30000000,  r =  0,   s = 4,   L = 300,   d = 0
## 
## 
## 
## Counters with expected numbers >= 10
## -----------------------------------------------
## Number of degrees of freedom          : 4117
## Chi-square statistic                  : 4183.44
## p-value of test                       :    0.23
## 
## -----------------------------------------------
## CPU time used                    :  00:01:25.02
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingIndep test:
## -----------------------------------------------
##    N =  1,  n = 30000000,  r = 26,   s = 4,   L = 300,   d = 0
## 
## 
## 
## Counters with expected numbers >= 10
## -----------------------------------------------
## Number of degrees of freedom          : 4117
## Chi-square statistic                  : 4147.28
## p-value of test                       :    0.37
## 
## -----------------------------------------------
## CPU time used                    :  00:01:29.27
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingIndep test:
## -----------------------------------------------
##    N =  1,  n = 10000000,  r =  0,   s = 5,   L = 1200,   d = 0
## 
## 
## 
## Counters with expected numbers >= 10
## -----------------------------------------------
## Number of degrees of freedom          : 11825
## Chi-square statistic                  :11803.57
## p-value of test                       :    0.55
## 
## -----------------------------------------------
## CPU time used                    :  00:01:33.79
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_HammingIndep test:
## -----------------------------------------------
##    N =  1,  n = 10000000,  r = 25,   s = 5,   L = 1200,   d = 0
## 
## 
## 
## Counters with expected numbers >= 10
## -----------------------------------------------
## Number of degrees of freedom          : 11825
## Chi-square statistic                  :11791.39
## p-value of test                       :    0.58
## 
## -----------------------------------------------
## CPU time used                    :  00:01:38.25
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_Run test:
## -----------------------------------------------
##    N =  1,  n = 2000000000,  r =  0,   s =    3
## 
## 
## -----------------------------------------------
## Total number of 1 runs:  2000000000
## 
## Number of degrees of freedom          :   54
## Chi2 statistic for number of runs     :   62.56
## p-value of test                       :    0.20
## 
## 
## -----------------------------------------------
## Total number of bits:  7999957470
## 
## Normal statistic for number of bits   :   -0.34
## p-value of test                       :    0.63
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:16.00
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_Run test:
## -----------------------------------------------
##    N =  1,  n = 2000000000,  r = 27,   s =    3
## 
## 
## -----------------------------------------------
## Total number of 1 runs:  2000000000
## 
## Number of degrees of freedom          :   54
## Chi2 statistic for number of runs     :   65.11
## p-value of test                       :    0.14
## 
## 
## -----------------------------------------------
## Total number of bits:  7999956321
## 
## Normal statistic for number of bits   :   -0.35
## p-value of test                       :    0.64
## 
## 
## 
## -----------------------------------------------
## CPU time used                    :  00:01:18.57
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_AutoCor test:
## -----------------------------------------------
##    N = 10,  n = 1000000030,  r =  0,   s = 3,   d = 1
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.28
## p-value of test                       :    0.18
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.10
## p-value of test                       :    0.76
## 
## Anderson-Darling statistic = A2       :    0.50
## p-value of test                       :    0.74
## 
## Tests on the sum of all N observations
## Standardized normal statistic         :   -0.51
## p-value of test                       :    0.69
## 
## Sample variance                       :    0.71
## p-value of test                       :    0.70
## 
## -----------------------------------------------
## CPU time used                    :  00:02:49.27
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_AutoCor test:
## -----------------------------------------------
##    N = 10,  n = 1000000029,  r =  0,   s = 3,   d = 3
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :    0.13
## p-value of test                       :    0.66
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.17
## p-value of test                       :    0.51
## 
## Anderson-Darling statistic = A2       :    0.30
## p-value of test                       :    0.94
## 
## Tests on the sum of all N observations
## Standardized normal statistic         :   0.069
## p-value of test                       :    0.47
## 
## Sample variance                       :    0.68
## p-value of test                       :    0.73
## 
## -----------------------------------------------
## CPU time used                    :  00:02:30.81
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_AutoCor test:
## -----------------------------------------------
##    N = 10,  n = 1000000030,  r = 27,   s = 3,   d = 1
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.095
## p-value of test                       :    0.78
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.30
## p-value of test                       :    0.14
## 
## Anderson-Darling statistic = A2       :    1.01
## p-value of test                       :    0.35
## 
## Tests on the sum of all N observations
## Standardized normal statistic         :    0.45
## p-value of test                       :    0.33
## 
## Sample variance                       :    1.52
## p-value of test                       :    0.13
## 
## -----------------------------------------------
## CPU time used                    :  00:02:51.88
## 
## Generator state:
## 
## 
## 
## 
## ***********************************************************
## HOST = Thijss-iMac.local, Darwin
## 
## sitmo
## 
## 
## sstring_AutoCor test:
## -----------------------------------------------
##    N = 10,  n = 1000000029,  r = 27,   s = 3,   d = 3
## 
## 
## -----------------------------------------------
## 
## Kolmogorov-Smirnov+ statistic = D+    :   0.079
## p-value of test                       :    0.84
## 
## Kolmogorov-Smirnov- statistic = D-    :    0.18
## p-value of test                       :    0.48
## 
## Anderson-Darling statistic = A2       :    0.59
## p-value of test                       :    0.65
## 
## Tests on the sum of all N observations
## Standardized normal statistic         :    0.78
## p-value of test                       :    0.22
## 
## Sample variance                       :    1.85
## p-value of test                       :    0.05
## 
## -----------------------------------------------
## CPU time used                    :  00:02:32.94
## 
## Generator state:
## 
## 
## 
## 
## 
## ========= Summary results of BigCrush =========
## 
##  Version:          TestU01 1.2.3
##  Generator:        sitmo
##  Number of statistics:  160
##  Total CPU time:   03:44:06.82
## 
##  All tests were passed

