% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{load_outputs}
\alias{load_outputs}
\alias{load_outputs_from_ref}
\title{Load one or more output objects from file.}
\usage{
load_outputs(dir, model_name, index, method_name, out_names = NULL,
  out_loc = "out", more_info = FALSE, simulator.files = NULL)

load_outputs_from_ref(ref, out_names = NULL)
}
\arguments{
\item{dir}{the directory passed to \code{\link{generate_model}})}

\item{model_name}{the \code{\linkS4class{Model}} object's \code{name}}

\item{index}{a vector of positive integers.}

\item{method_name}{the \code{\linkS4class{Method}} object's \code{name}}

\item{out_names}{a character vector of which elements of output should be
loaded. If NULL, then all elements are loaded.}

\item{out_loc}{only needed if it was used in call to
\code{\link{run_method}}.}

\item{more_info}{if TRUE, then returns additional information such as
state of RNG after calling \code{\link{simulate_from_model}}}

\item{simulator.files}{if NULL, then \code{getOption("simulator.files")}
will be used.}

\item{ref}{an object of class \code{\linkS4class{OutputRef}}}
}
\description{
After \code{\link{run_method}} has been called, this function can
be used to load one or more of the saved \code{\linkS4class{Output}} object(s).
If multiple indices are provided, these will be combined
into a new single \code{\linkS4class{Output}} object.
If simulation object is available, it is easier to use the function
\code{\link{output}} to load it.
}
\seealso{
\code{\link{run_method}} \code{\link{output}}
}
\keyword{internal}

