% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitsimts.R
\name{select}
\alias{select}
\title{Time Series Model Selection}
\usage{
select(model, Xt, include.mean = TRUE, criterion = "aic",
  plot = TRUE)
}
\arguments{
\item{model}{A time series model (only ARIMA are currently supported).}

\item{Xt}{A \code{vector} of time series data.}

\item{include.mean}{A \code{boolean} indicating whether to fit ARIMA with the mean or not.}

\item{criterion}{A \code{string} indicating which model selection criterion should be used (possible values: \code{"aic"} (default), \code{"bic"}, \code{"hq"}).}

\item{plot}{A \code{boolean} indicating whether a model selection plot is returned or not.}
}
\description{
This function performs model fitting and calculates the model selection criteria to be plotted.
}
\examples{
set.seed(763)
Xt = gen_gts(100, AR(phi = c(0.2, -0.5, 0.4), sigma2 = 1))
select(AR(5), Xt, include.mean = FALSE)

Xt = gen_gts(100, MA(theta = c(0.2, -0.5, 0.4), sigma2 = 1))
select(MA(5), Xt, include.mean = FALSE)

Xt = gen_gts(500, ARMA(ar = 0.5, ma = c(0.5, -0.5, 0.4), sigma2 = 1))
select(ARMA(5,3), Xt, criterion = "hq", include.mean = FALSE)

}
\author{
Stéphane Guerrier and Yuming Zhang
}
