% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_2nd_ar1}
\alias{deriv_2nd_ar1}
\title{Analytic second derivative matrix for AR(1) process}
\usage{
deriv_2nd_ar1(phi, sigma2, tau)
}
\arguments{
\item{phi}{A \code{double} corresponding to the phi coefficient of an AR(1) process.}

\item{sigma2}{A \code{double} corresponding to the error term of an AR(1) process.}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{matrix} with the first column containing the
 second partial derivative with respect to \eqn{\phi}{phi} and
  the second column contains the second partial derivative with 
  respect to \eqn{\sigma ^2}{sigma^2}
}
\description{
Calculates the second derivative for the AR(1) process and places it into a matrix form.
The matrix form in this case is for convenience of the calculation.
}
\section{Process Haar WV Second Derivative}{

Taking the second derivative with respect to \eqn{\phi}{phi} yields:
\deqn{\frac{{{\partial ^2}}}{{\partial {\phi ^2}}}\nu _j^2\left( \phi, \sigma ^2  \right) = \frac{2 \sigma ^2 \left(\left(\phi ^2-1\right) \tau _j \left(2 (\phi  (7 \phi +4)+1) \phi ^{\frac{\tau _j}{2}-1}-(\phi  (7 \phi +4)+1) \phi ^{\tau _j-1}+3 (\phi +1)^2\right)+\left(\phi ^2-1\right)^2 \tau _j^2 \left(\phi ^{\frac{\tau _j}{2}}-1\right) \phi ^{\frac{\tau _j}{2}-1}+4 (3 \phi +1) \left(\phi ^2+\phi +1\right) \left(\phi ^{\tau _j}-4 \phi ^{\frac{\tau _j}{2}}+3\right)\right)}{(\phi -1)^5 (\phi +1)^3 \tau _j^2} }{d^2/dphi^2 nu[j]^2(phi, sigma2) = 2*sigma2*(4*(1 + 3*phi)*(1 + phi + phi^2)*
(3 - 4*phi^(tau[j]/2) + phi^tau[j]) + (-1 + phi^2)*
  (3*(1 + phi)^2 + 2*phi^(tau[j]/2 - 1)*(1 + phi*(4 + 7*phi)) - 
     phi^(tau[j] - 1)*(1 + phi*(4 + 7*phi)))*
 tau[j] + phi^(tau[j]/2 - 1)*(-1 + phi^2)^2*(-1 + phi^(tau[j]/2))*tau[j]^2)/((-1 + phi)^5*(1 + phi)^3*tau[j]^2)}

Taking the second derivative with respect to \eqn{\sigma^2}{sigma^2} yields:
\deqn{\frac{{{\partial ^2}}}{{\partial {\sigma ^4}}}\nu _j^2\left( \sigma ^2  \right) = 0 }{d^2/dsigma2^2 nu[j]^2(phi, sigma2) = 0}

Taking the derivative with respect to \eqn{\phi}{phi} and \eqn{\sigma ^2}{sigma2} yields:
\deqn{\frac{{{\partial ^2}}}{{\partial {\phi } \partial {\sigma ^2}}}\nu _j^2\left( \phi, \sigma ^2  \right) = \frac{2 \left(\left(\phi ^2-1\right) \tau _j \left(\phi ^{\tau _j}-2 \phi ^{\frac{\tau _j}{2}}-\phi -1\right)-(\phi  (3 \phi +2)+1) \left(\phi ^{\tau _j}-4 \phi ^{\frac{\tau _j}{2}}+3\right)\right)}{(\phi -1)^4 (\phi +1)^2 \tau _j^2} }{d/dsigma * d/dphi nu[j]^2(phi, sigma2) = (2*((-(3 - 4*phi^(tau[j]/2) + phi^tau[j]))*(1 + phi*(2 + 3*phi)) + (-1 + phi^2)*(-1 - phi - 2*phi^(tau[j]/2) + phi^tau[j])*tau[j]))/((-1 + phi)^4*(1 + phi)^2*tau[j]^2)}
}

\author{
James Joseph Balamuta (JJB)
}
