% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_data.R
\name{defRead}
\alias{defRead}
\title{Read external csv data set definitions}
\usage{
defRead(filen, id = "id")
}
\arguments{
\item{filen}{String file name, including full path. Must be a csv file.}

\item{id}{string that includes name of id field. Defaults to "id"}
}
\value{
A data.table with data set definitions
}
\description{
Read external csv data set definitions
}
\examples{
# Create temporary external "csv" file

test1 <- c(
  "varname,formula,variance,dist,link",
  "nr,7, 0,nonrandom,identity",
  "x1,.4, 0,binary,identity",
  "y1,nr + x1 * 2,8,normal,identity",
  "y2,nr - 0.2 * x1,0,poisson, log"
)

tfcsv <- tempfile()
writeLines(test1, tfcsv)

# Read external csv file stored in file "tfcsv"

defs <- defRead(tfcsv, id = "myID")
defs

unlink(tfcsv)

# Generate data based on external definition

genData(5, defs)
}
\seealso{
[distributions]
}
\concept{condition}
\concept{define_data}
