% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{glimpse_na}
\alias{glimpse_na}
\alias{\%?>\%}
\title{Show the number of (remaining) missing values.}
\usage{
glimpse_na(x, show_only_missing = TRUE, ...)

lhs \%?>\% rhs
}
\arguments{
\item{x}{an R object caryying data (e.g. \code{data.frame})}

\item{show_only_missing}{if \code{TRUE} only columns with \code{NA}'s will be
printed.}

\item{...}{arguments passed to \code{\link{na_status}}.}

\item{lhs}{left hand side of pipe}

\item{rhs}{right hand side of pipe}
}
\description{
Quick indication of the amount and location of missing values.
The function uses \code{\link{na_status}} to print the missing values, but
returns the original \code{x} (invisibly) and therefore can be used in an imputation pipeline
to peek at the NA's status.
}
\details{
\code{glimpse_na} is especially helpful when interactively adding imputation methods.
\code{glimpse_na} is named after \code{\link[dplyr]{glimpse}} in \code{dplyr}.

Operator \code{\%?>\%} is syntactic sugar: it inserts a \code{glimpse_na} in
the pipe.
}
\examples{
if (requireNamespace("dplyr")){
   library(dplyr)
   
   irisNA <- iris
   irisNA[1:3,1] <- irisNA[3:7,2] <- NA
   
   # How many NA's?
   na_status(irisNA)
   
   # add an imputation method one at a time
   iris_imputed <-
     irisNA \%>\% 
     glimpse_na() # same as above
   
   # ok, glimpse_na says "Sepal.Width" has NA's
   # fix that:
   
   iris_imputed <-
     irisNA \%>\% 
     impute_const(Sepal.Width ~ 7) \%>\% 
     glimpse_na() # end NA
   
   # Sepal.Length is having NA's
   
   iris_imputed <-
     irisNA \%>\% 
     impute_const(Sepal.Width ~ 7) \%>\%
     impute_cart(Sepal.Length ~ .) \%>\%  
     glimpse_na() # end NA
   
   # in an existing imputation pipeline we can peek with
   # glimpse_na or \%?>\%
   
   iris_imputed <-
     irisNA \%>\% 
     glimpse_na() \%>\%     # shows the begin NA
     impute_const(Sepal.Width ~ 7) \%>\% 
     glimpse_na() \%>\%     # after 1 imputation
     impute_cart(Sepal.Length ~ .) \%>\%  
     glimpse_na()         # end NA
     
   # or
   iris_imputed <-
     irisNA \%?>\% 
     impute_const(Sepal.Width ~ 7) \%?>\% 
     impute_cart(Sepal.Length ~ .)
     
   na_status(iris_imputed)  
}
}
