% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_boxplot.R
\name{ggplot_boxplot_facet}
\alias{ggplot_boxplot_facet}
\title{Boxplot ggplot that is facetted.}
\usage{
ggplot_boxplot_facet(data, x_var, y_var = NULL, facet_var,
  group_var = NULL, stat = "boxplot", pal = NULL, width = 0.5,
  alpha = 0.1, line_size = 0.5, point_size = 1, title = "[Title]",
  title_wrap = 70, subtitle = NULL, subtitle_wrap = 80,
  x_expand = NULL, x_labels = waiver(), x_pretty_n = 5,
  x_title = "[X title]", x_title_wrap = 50, y_balance = FALSE,
  y_expand = NULL, y_labels = waiver(), y_pretty_n = 5,
  y_title = "[Y title]", y_title_wrap = 50, y_trans = "identity",
  y_zero = TRUE, y_zero_line = NULL, facet_ncol = NULL,
  facet_nrow = NULL, facet_scales = "fixed", caption = NULL,
  caption_wrap = 80, font_family = "Helvetica",
  font_size_title = NULL, font_size_body = NULL)
}
\arguments{
\item{data}{An tibble or dataframe. Required input.}

\item{x_var}{Unquoted variable to be on the x axis. Required input.}

\item{y_var}{Unquoted numeric variable to be on the y axis. Defaults to NULL. Required if stat equals "boxplot".}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{group_var}{Unquoted variable to be the grouping variable Defaults to NULL. Only applicable if stat equals "boxplot".}

\item{stat}{String of "boxplot" or "identity". Defaults to "boxplot". If identity is selected, data provided must be grouped by the x_var and facet_var with ymin, lower, middle, upper, ymax variables. Note "identity" does not provide outliers.}

\item{pal}{Character vector of hex codes. Defaults to viridis. Use the pals package to find a suitable palette.}

\item{width}{Width of the box. Defaults to 0.5.}

\item{alpha}{The alpha of the fill. Defaults to 0.1.}

\item{line_size}{The size of the outlines of boxplots. Defaults to 0.5.}

\item{point_size}{The size of the outliers. Defaults to 1.}

\item{title}{Title string. Defaults to "[Title]".}

\item{title_wrap}{Number of characters to wrap the title to. Defaults to 70.}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{subtitle_wrap}{Number of characters to wrap the subtitle to. Defaults to 80.}

\item{x_expand}{A vector of range expansion constants used to add some padding on the x scale.}

\item{x_labels}{Adjust the  x scale labels through a function or vector.}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 5. Only applicable to a x variable that is categorical or date.}

\item{x_title}{X axis title string. Defaults to "[X title]".}

\item{x_title_wrap}{Number of characters to wrap the x title to. Defaults to 50.}

\item{y_balance}{Add balance to the y axis so that zero is in the centre of the y scale. Only applicable where facet_scales equals "fixed" or "free_x".}

\item{y_expand}{A vector of range expansion constants used to add some padding on the y scale.}

\item{y_labels}{Adjust the  y scale labels through a function or vector.}

\item{y_pretty_n}{The desired number of intervals on the y axis, as calculated by the pretty algorithm. Defaults to 5.}

\item{y_title}{Y axis title string. Defaults to "[Y title]".}

\item{y_title_wrap}{Number of characters to wrap the y title to. Defaults to 50.}

\item{y_trans}{TRUEransformation of y-axis scale (e.g. "signed_sqrt"). Defaults to "identity", which has no transformation.}

\item{y_zero}{TRUE or FALSE of whether the minimum of the y scale is zero. Defaults to TRUE.}

\item{y_zero_line}{TRUE or FALSE whether to add a zero reference line to the y axis. Defaults to NULL, which is TRUE if there are positive and negative values in y_var. Otherwise it is FALSE.}

\item{facet_ncol}{The number of columns of facetted plots.}

\item{facet_nrow}{The number of rows of facetted plots.}

\item{facet_scales}{Whether facet_scales should be "fixed" across facets, "free" in both directions, or free in just one direction (i.e. "free_x" or "free_y"). Defaults to "fixed".}

\item{caption}{Caption title string. Defaults to NULL.}

\item{caption_wrap}{Number of characters to wrap the caption to. Defaults to 80.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}
}
\value{
A ggplot object.
}
\description{
Boxplot ggplot that is facetted, but not coloured.
}
\examples{
library(dplyr)

plot_data <- ggplot2::diamonds \%>\%
  mutate(price_thousands = (price / 1000)) \%>\%
  slice_sample(prop = 0.05)

ggplot_boxplot_facet(plot_data, cut, price_thousands, color)

}
