% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapperHelper.R
\name{findSimplaceInstallations}
\alias{findSimplaceInstallations}
\title{Search for simplace installations and returns results as vector}
\usage{
findSimplaceInstallations(
  directories = c(),
  tryStandardDirs = TRUE,
  firstMatchOnly = FALSE,
  simulationsDir = "simplace_run",
  ignoreSimulationsDir = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{directories}{a list of additional directories where to look -}

\item{tryStandardDirs}{whether to check for typical installation directories (default)}

\item{firstMatchOnly}{returns only the first installation found}

\item{simulationsDir}{directory that contains user simulations (e.g. simplace_run)}

\item{ignoreSimulationsDir}{don't check for the simulation dir}

\item{verbose}{prints messages if no or more than one installation found}
}
\value{
matching directory/ies as character vector
}
\description{
Checks directories if they contain simplace_core, simplace_modules and 
optionally simplace_run (or a data directory given by the user) and returns
the matches.
There is no check whether the installation is really working.
}
\details{
Beside the checks for some standard directories (like home directory, current
working dir and drives c: to g:) and their subdirectories (workspace, simplace,
java/simplace) the user can give a vector of additional directories.
}
